/*
 * Decompiled with CFR 0.152.
 */
package reactivejson;

import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.async_.JsonFactory;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import reactivejson.Tokenizer;

public class NonBlockingObjectReader {
    private final Tokenizer tokenizer;
    private final ObjectReader reader;

    public NonBlockingObjectReader(JsonFactory jsonFactory, boolean tokenizeArrayElements, ObjectReader reader) throws IOException {
        this.tokenizer = new Tokenizer(jsonFactory, tokenizeArrayElements);
        this.reader = reader;
    }

    public <T> List<T> readObjects(ByteBuffer byteBuffer) throws IOException {
        List<TokenBuffer> tokenBuffers = this.tokenizer.tokenize(byteBuffer);
        ArrayList<Object> objects = new ArrayList<Object>(tokenBuffers.size());
        for (TokenBuffer tokenBuffer : tokenBuffers) {
            objects.add(this.reader.readValue(tokenBuffer.asParser((ObjectCodec)this.reader)));
        }
        return objects;
    }

    public <T> List<T> endOfInput() throws IOException {
        List<TokenBuffer> tokenBuffers = this.tokenizer.endOfInput();
        if (tokenBuffers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Object> objects = new ArrayList<Object>(tokenBuffers.size());
        for (TokenBuffer tokenBuffer : tokenBuffers) {
            objects.add(this.reader.readValue(tokenBuffer.asParser((ObjectCodec)this.reader)));
        }
        return objects;
    }
}

