/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mx.adapters;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.time.Year;
import java.time.format.DateTimeFormatter;

public class YearAdapter
extends XmlAdapter<String, Year> {
    private String YEAR_FORMAT = "yyyy";
    private DateTimeFormatter dtf = DateTimeFormatter.ofPattern(this.YEAR_FORMAT);

    public YearAdapter() {
    }

    public YearAdapter(DateTimeFormatter ofPattern) {
        this.dtf = ofPattern;
    }

    public Year unmarshal(String value) throws Exception {
        return Year.parse(value, this.dtf);
    }

    public String marshal(Year value) throws Exception {
        if (value != null) {
            return this.dtf.format(value);
        }
        return null;
    }

    public String toString() {
        return "YearAdapter{ " + this.YEAR_FORMAT + " }";
    }
}

