/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.builder.standard.internal;

import com.speedment.jpastreamer.builder.standard.internal.BaseBuilderState;
import com.speedment.jpastreamer.builder.standard.internal.StreamBuilderUtil;
import com.speedment.jpastreamer.pipeline.intermediate.IntermediateOperation;
import com.speedment.jpastreamer.pipeline.terminal.TerminalOperation;
import com.speedment.jpastreamer.renderer.RenderResult;
import java.util.Objects;
import java.util.stream.BaseStream;
import java.util.stream.Stream;

abstract class BaseStreamBuilder<E, T, S extends BaseStream<T, S>>
implements BaseStream<T, S> {
    private final BaseBuilderState<E> baseState;
    private boolean linkedConsumedOrClosed;

    BaseStreamBuilder(BaseBuilderState<E> baseState) {
        this.baseState = Objects.requireNonNull(baseState);
    }

    @Override
    public boolean isParallel() {
        return this.baseState.pipeline().isParallel();
    }

    @Override
    public S sequential() {
        this.baseState.pipeline().parallel();
        return this.self();
    }

    @Override
    public S parallel() {
        this.baseState.pipeline().parallel();
        return this.self();
    }

    @Override
    public S unordered() {
        this.baseState.pipeline().ordered(false);
        return this.self();
    }

    @Override
    public S onClose(Runnable closeHandler) {
        this.baseState.pipeline().closeHandlers().add(closeHandler);
        return this.self();
    }

    @Override
    public void close() {
        this.closed();
        StreamBuilderUtil.runAll(this.baseState.pipeline().closeHandlers());
        this.baseState.pipeline().closeHandlers().clear();
    }

    protected BaseBuilderState<E> baseState() {
        return this.baseState;
    }

    protected void linked() {
        this.linkedConsumedOrClosed = true;
    }

    protected void consumed() {
        this.linkedConsumedOrClosed = true;
    }

    protected void closed() {
        this.linkedConsumedOrClosed = true;
    }

    protected void assertNotLikedConsumedOrClosed() {
        if (this.linkedConsumedOrClosed) {
            throw new IllegalStateException("Stream has already been linked, consumed or closed");
        }
    }

    protected void add(IntermediateOperation<S, ?> intermediateOperation) {
        this.assertNotLikedConsumedOrClosed();
        this.baseState.pipeline().intermediateOperations().add(intermediateOperation);
    }

    protected void set(TerminalOperation<S, ?> terminalOperation) {
        this.assertNotLikedConsumedOrClosed();
        this.consumed();
        this.baseState.pipeline().terminatingOperation(terminalOperation);
    }

    protected <R> R renderAndThenApply() {
        RenderResult<E, ?, ?> renderResult = this.renderResult();
        return renderResult.terminalOperation().function().apply(renderResult.stream());
    }

    protected long renderAndThenApplyAsLong() {
        RenderResult<E, ?, ?> renderResult = this.renderResult();
        return renderResult.terminalOperation().toLongFunction().applyAsLong(renderResult.stream());
    }

    protected int renderAndThenApplyAsInt() {
        RenderResult<E, ?, ?> renderResult = this.renderResult();
        return renderResult.terminalOperation().toIntFunction().applyAsInt(renderResult.stream());
    }

    protected double renderAndThenApplyAsDouble() {
        RenderResult<E, ?, ?> renderResult = this.renderResult();
        return renderResult.terminalOperation().toDoubleFunction().applyAsDouble(renderResult.stream());
    }

    protected boolean renderAndThenTest() {
        RenderResult<E, ?, ?> renderResult = this.renderResult();
        return renderResult.terminalOperation().predicate().test(renderResult.stream());
    }

    protected void renderAndThenAccept() {
        RenderResult<E, ?, ?> renderResult = this.renderResult();
        renderResult.terminalOperation().consumer().accept(renderResult.stream());
    }

    protected long renderCount() {
        RenderResult<E, ?, ?> renderResult = this.renderResult();
        if (renderResult.root().equals(Long.class) || this.baseState.pipeline().intermediateOperations().isEmpty()) {
            Stream stream = (Stream)renderResult.stream();
            return stream.mapToLong(Number::longValue).sum();
        }
        return renderResult.terminalOperation().toLongFunction().applyAsLong(renderResult.stream());
    }

    private RenderResult<E, ?, ?> renderResult() {
        return this.baseState.renderer().render(this.baseState.pipeline(), this.baseState.streamConfiguration());
    }

    private S self() {
        return (S)this;
    }
}

