/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.projection.internal;

import com.speedment.jpastreamer.field.Field;
import com.speedment.jpastreamer.projection.Projection;
import com.speedment.jpastreamer.projection.internal.TupleContext;
import jakarta.persistence.Tuple;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public final class InternalProjection<ENTITY>
implements Projection<ENTITY> {
    private final Class<ENTITY> entityClass;
    private final Set<Field<ENTITY>> fields;
    private final TupleContext<ENTITY> tupleContext;

    public InternalProjection(Class<ENTITY> entityClass, Set<Field<ENTITY>> fields) {
        this.entityClass = Objects.requireNonNull(entityClass);
        this.fields = Collections.unmodifiableSet(fields);
        this.tupleContext = new TupleContext<ENTITY>(entityClass, fields);
    }

    @Override
    public Class<ENTITY> entityClass() {
        return this.entityClass;
    }

    @Override
    public Set<Field<ENTITY>> fields() {
        return this.fields;
    }

    @Override
    public Tuple apply(ENTITY entity) {
        return this.tupleContext.create(entity);
    }
}

