/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute;

import com.speedment.runtime.compute.ToEnumNullable;
import com.speedment.runtime.compute.ToInt;
import com.speedment.runtime.compute.ToString;
import com.speedment.runtime.compute.expression.Expression;
import com.speedment.runtime.compute.expression.ExpressionType;
import com.speedment.runtime.compute.internal.ToEnumImpl;
import com.speedment.runtime.compute.internal.expression.ComposedUtil;
import com.speedment.runtime.compute.internal.expression.MapperUtil;
import com.speedment.runtime.compute.trait.HasCompare;
import com.speedment.runtime.compute.trait.HasCompose;
import com.speedment.runtime.compute.trait.HasHash;
import com.speedment.runtime.compute.trait.HasMap;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public interface ToEnum<T, E extends Enum<E>>
extends Expression<T>,
Function<T, E>,
HasMap<T, UnaryOperator<E>, ToEnum<T, E>>,
HasHash<T>,
HasCompare<T>,
HasCompose<T> {
    public static <T, E extends Enum<E>> ToEnum<T, E> of(Class<E> enumClass, Function<T, E> lambda) {
        return new ToEnumImpl<T, E>(enumClass, lambda);
    }

    public Class<E> enumClass();

    @Override
    default public ExpressionType expressionType() {
        return ExpressionType.ENUM;
    }

    @Override
    public E apply(T var1);

    default public ToInt<T> asOrdinal() {
        return t -> ((Enum)this.apply(t)).ordinal();
    }

    default public ToString<T> asName() {
        return t -> ((Enum)this.apply(t)).name();
    }

    @Override
    default public ToEnum<T, E> map(UnaryOperator<E> mapper) {
        return MapperUtil.mapEnum(this, mapper);
    }

    @Override
    default public long hash(T object) {
        return ((Enum)this.apply((Object)object)).hashCode();
    }

    @Override
    default public int compare(T first, T second) {
        return ((Enum)this.apply((Object)first)).compareTo(this.apply((Object)second));
    }

    @Override
    default public <V> ToEnumNullable<V, E> compose(Function<? super V, ? extends T> before) {
        Function<? super V, ? extends T> casted = before;
        return ComposedUtil.composeToEnum(casted, this);
    }
}

