/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute;

import com.speedment.common.function.FloatToDoubleFunction;
import com.speedment.common.function.FloatUnaryOperator;
import com.speedment.common.function.ToFloatFunction;
import com.speedment.runtime.compute.ToByte;
import com.speedment.runtime.compute.ToDouble;
import com.speedment.runtime.compute.ToFloatNullable;
import com.speedment.runtime.compute.ToInt;
import com.speedment.runtime.compute.ToLong;
import com.speedment.runtime.compute.expression.Expression;
import com.speedment.runtime.compute.expression.ExpressionType;
import com.speedment.runtime.compute.expression.Expressions;
import com.speedment.runtime.compute.internal.expression.CastUtil;
import com.speedment.runtime.compute.internal.expression.ComposedUtil;
import com.speedment.runtime.compute.internal.expression.MapperUtil;
import com.speedment.runtime.compute.trait.HasAbs;
import com.speedment.runtime.compute.trait.HasAsDouble;
import com.speedment.runtime.compute.trait.HasAsInt;
import com.speedment.runtime.compute.trait.HasAsLong;
import com.speedment.runtime.compute.trait.HasCompare;
import com.speedment.runtime.compute.trait.HasCompose;
import com.speedment.runtime.compute.trait.HasDivide;
import com.speedment.runtime.compute.trait.HasHash;
import com.speedment.runtime.compute.trait.HasMap;
import com.speedment.runtime.compute.trait.HasMapToDouble;
import com.speedment.runtime.compute.trait.HasMinus;
import com.speedment.runtime.compute.trait.HasMultiply;
import com.speedment.runtime.compute.trait.HasNegate;
import com.speedment.runtime.compute.trait.HasPlus;
import com.speedment.runtime.compute.trait.HasPow;
import com.speedment.runtime.compute.trait.HasSign;
import com.speedment.runtime.compute.trait.HasSqrt;
import java.util.function.Function;

@FunctionalInterface
public interface ToFloat<T>
extends Expression<T>,
ToFloatFunction<T>,
HasAsDouble<T>,
HasAsInt<T>,
HasAsLong<T>,
HasAbs<ToFloat<T>>,
HasSign<ToByte<T>>,
HasSqrt<ToDouble<T>>,
HasNegate<ToFloat<T>>,
HasPow<T>,
HasPlus<T>,
HasMinus<T>,
HasMultiply<T>,
HasDivide<T>,
HasMap<T, FloatUnaryOperator, ToFloat<T>>,
HasMapToDouble<T, FloatToDoubleFunction>,
HasHash<T>,
HasCompare<T>,
HasCompose<T> {
    public static <T> ToFloat<T> of(ToFloatFunction<T> lambda) {
        if (lambda instanceof ToFloat) {
            return (ToFloat)lambda;
        }
        return arg_0 -> lambda.applyAsFloat(arg_0);
    }

    public float applyAsFloat(T var1);

    @Override
    default public ExpressionType expressionType() {
        return ExpressionType.FLOAT;
    }

    @Override
    default public ToDouble<T> asDouble() {
        return CastUtil.castFloatToDouble(this);
    }

    @Override
    default public ToInt<T> asInt() {
        return CastUtil.castFloatToInt(this);
    }

    @Override
    default public ToLong<T> asLong() {
        return CastUtil.castFloatToLong(this);
    }

    @Override
    default public ToDouble<T> mapToDouble(FloatToDoubleFunction operator) {
        return MapperUtil.mapFloatToDouble(this, operator);
    }

    @Override
    default public ToFloat<T> map(FloatUnaryOperator operator) {
        return MapperUtil.mapFloat(this, operator);
    }

    @Override
    default public ToFloat<T> abs() {
        return Expressions.abs(this);
    }

    @Override
    default public ToByte<T> sign() {
        return Expressions.sign(this);
    }

    @Override
    default public ToDouble<T> sqrt() {
        return Expressions.sqrt(this);
    }

    @Override
    default public ToFloat<T> negate() {
        return Expressions.negate(this);
    }

    @Override
    default public ToDouble<T> pow(int power) {
        return Expressions.pow(this, power);
    }

    @Override
    default public ToDouble<T> pow(double power) {
        return Expressions.pow(this, power);
    }

    @Override
    default public ToDouble<T> pow(ToInt<T> power) {
        return Expressions.pow(this, power);
    }

    @Override
    default public ToDouble<T> pow(ToDouble<T> power) {
        return Expressions.pow(this, power);
    }

    @Override
    default public ToFloat<T> plus(byte other) {
        return Expressions.plus(this, (int)other);
    }

    @Override
    default public ToFloat<T> plus(ToByte<T> other) {
        return Expressions.plus(this, other.asInt());
    }

    @Override
    default public ToFloat<T> plus(int other) {
        return Expressions.plus(this, other);
    }

    @Override
    default public ToFloat<T> plus(ToInt<T> other) {
        return Expressions.plus(this, other);
    }

    @Override
    default public ToDouble<T> plus(long other) {
        return Expressions.plus(this, other);
    }

    @Override
    default public ToDouble<T> plus(ToLong<T> other) {
        return Expressions.plus(this, other);
    }

    @Override
    default public ToDouble<T> plus(double other) {
        return Expressions.plus(this.asDouble(), other);
    }

    @Override
    default public ToDouble<T> plus(ToDouble<T> other) {
        return Expressions.plus(this.asDouble(), other);
    }

    @Override
    default public ToFloat<T> minus(byte other) {
        return Expressions.minus(this, (int)other);
    }

    @Override
    default public ToFloat<T> minus(ToByte<T> other) {
        return Expressions.minus(this, other.asInt());
    }

    @Override
    default public ToFloat<T> minus(int other) {
        return Expressions.minus(this, other);
    }

    @Override
    default public ToFloat<T> minus(ToInt<T> other) {
        return Expressions.minus(this, other);
    }

    @Override
    default public ToDouble<T> minus(long other) {
        return Expressions.minus(this, other);
    }

    @Override
    default public ToDouble<T> minus(ToLong<T> other) {
        return Expressions.minus(this, other);
    }

    @Override
    default public ToDouble<T> minus(double other) {
        return Expressions.minus(this.asDouble(), other);
    }

    @Override
    default public ToDouble<T> minus(ToDouble<T> other) {
        return Expressions.minus(this.asDouble(), other);
    }

    @Override
    default public ToFloat<T> multiply(byte other) {
        return Expressions.multiply(this, (int)other);
    }

    @Override
    default public ToFloat<T> multiply(ToByte<T> other) {
        return Expressions.multiply(this, other.asInt());
    }

    @Override
    default public ToFloat<T> multiply(int other) {
        return Expressions.multiply(this, other);
    }

    @Override
    default public ToFloat<T> multiply(ToInt<T> other) {
        return Expressions.multiply(this, other);
    }

    @Override
    default public ToDouble<T> multiply(long other) {
        return Expressions.multiply(this, other);
    }

    @Override
    default public ToDouble<T> multiply(ToLong<T> other) {
        return Expressions.multiply(this, other);
    }

    @Override
    default public ToDouble<T> multiply(double other) {
        return Expressions.multiply(this.asDouble(), other);
    }

    @Override
    default public ToDouble<T> multiply(ToDouble<T> other) {
        return Expressions.multiply(this.asDouble(), other);
    }

    @Override
    default public ToDouble<T> divide(int divisor) {
        return Expressions.divide(this, divisor);
    }

    @Override
    default public ToDouble<T> divide(ToInt<T> divisor) {
        return Expressions.divide(this, divisor);
    }

    @Override
    default public ToDouble<T> divide(long divisor) {
        return Expressions.divide(this, divisor);
    }

    @Override
    default public ToDouble<T> divide(ToLong<T> divisor) {
        return Expressions.divide(this, divisor);
    }

    @Override
    default public ToDouble<T> divide(double divisor) {
        return Expressions.divide(this, divisor);
    }

    @Override
    default public ToDouble<T> divide(ToDouble<T> divisor) {
        return Expressions.divide(this, divisor);
    }

    @Override
    default public long hash(T object) {
        float f = this.applyAsFloat(object);
        return f != 0.0f ? (long)Float.floatToIntBits(f) : 0L;
    }

    @Override
    default public int compare(T first, T second) {
        return Float.compare(this.applyAsFloat(first), this.applyAsFloat(second));
    }

    @Override
    default public <V> ToFloatNullable<V> compose(Function<? super V, ? extends T> before) {
        Function<? super V, ? extends T> casted = before;
        return ComposedUtil.composeToFloat(casted, this);
    }
}

