/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute;

import com.speedment.common.function.FloatToDoubleFunction;
import com.speedment.common.function.FloatUnaryOperator;
import com.speedment.common.function.ToFloatFunction;
import com.speedment.runtime.compute.ToByteNullable;
import com.speedment.runtime.compute.ToDouble;
import com.speedment.runtime.compute.ToDoubleNullable;
import com.speedment.runtime.compute.ToFloat;
import com.speedment.runtime.compute.expression.Expression;
import com.speedment.runtime.compute.expression.ExpressionType;
import com.speedment.runtime.compute.expression.Expressions;
import com.speedment.runtime.compute.internal.expression.ComposedUtil;
import com.speedment.runtime.compute.internal.expression.OrElseGetUtil;
import com.speedment.runtime.compute.internal.expression.OrElseThrowUtil;
import com.speedment.runtime.compute.internal.expression.OrElseUtil;
import com.speedment.runtime.compute.trait.HasAbs;
import com.speedment.runtime.compute.trait.HasCompare;
import com.speedment.runtime.compute.trait.HasCompose;
import com.speedment.runtime.compute.trait.HasHash;
import com.speedment.runtime.compute.trait.HasMapIfPresent;
import com.speedment.runtime.compute.trait.HasMapToDoubleIfPresent;
import com.speedment.runtime.compute.trait.HasNegate;
import com.speedment.runtime.compute.trait.HasSign;
import com.speedment.runtime.compute.trait.HasSqrt;
import com.speedment.runtime.compute.trait.ToNullable;
import java.util.function.Function;

@FunctionalInterface
public interface ToFloatNullable<T>
extends Expression<T>,
ToFloatFunction<T>,
ToNullable<T, Float, ToFloat<T>>,
HasAbs<ToFloatNullable<T>>,
HasSign<ToByteNullable<T>>,
HasSqrt<ToDoubleNullable<T>>,
HasNegate<ToFloatNullable<T>>,
HasMapToDoubleIfPresent<T, FloatToDoubleFunction>,
HasMapIfPresent<T, FloatUnaryOperator, ToFloatNullable<T>>,
HasHash<T>,
HasCompare<T>,
HasCompose<T> {
    public static <T> ToFloatNullable<T> of(Function<T, Float> lambda) {
        if (lambda instanceof ToFloatNullable) {
            return (ToFloatNullable)lambda;
        }
        return lambda::apply;
    }

    @Override
    default public ExpressionType expressionType() {
        return ExpressionType.FLOAT_NULLABLE;
    }

    default public float applyAsFloat(T object) {
        return ((Float)this.apply(object)).floatValue();
    }

    @Override
    default public ToFloat<T> orThrow() {
        return OrElseThrowUtil.floatOrElseThrow(this);
    }

    @Override
    default public ToFloat<T> orElseGet(ToFloat<T> getter) {
        return OrElseGetUtil.floatOrElseGet(this, getter);
    }

    @Override
    default public ToFloat<T> orElse(Float value) {
        return OrElseUtil.floatOrElse(this, value.floatValue());
    }

    @Override
    default public ToFloatNullable<T> abs() {
        return Expressions.absOrNull(this);
    }

    @Override
    default public ToFloatNullable<T> negate() {
        return Expressions.negateOrNull(this);
    }

    @Override
    default public ToByteNullable<T> sign() {
        return Expressions.signOrNull(this);
    }

    @Override
    default public ToDoubleNullable<T> sqrt() {
        return Expressions.sqrtOrNull(this);
    }

    @Override
    default public ToDoubleNullable<T> mapToDoubleIfPresent(final FloatToDoubleFunction mapper) {
        final ToFloatNullable delegate = this;
        return new ToDoubleNullable<T>(){

            @Override
            public Double apply(T object) {
                return delegate.isNull(object) ? null : Double.valueOf(mapper.applyAsDouble(delegate.applyAsFloat(object)));
            }

            @Override
            public double applyAsDouble(T object) {
                return mapper.applyAsDouble(delegate.applyAsFloat(object));
            }

            @Override
            public ToDouble<T> orElseGet(ToDouble<T> getter) {
                return object -> delegate.isNull(object) ? getter.applyAsDouble(object) : mapper.applyAsDouble(delegate.applyAsFloat(object));
            }

            @Override
            public ToDouble<T> orElse(Double value) {
                return object -> delegate.isNull(object) ? value.doubleValue() : mapper.applyAsDouble(delegate.applyAsFloat(object));
            }

            @Override
            public boolean isNull(T object) {
                return delegate.isNull(object);
            }

            @Override
            public boolean isNotNull(T object) {
                return delegate.isNotNull(object);
            }
        };
    }

    @Override
    default public ToFloatNullable<T> mapIfPresent(final FloatUnaryOperator mapper) {
        final ToFloatNullable delegate = this;
        return new ToFloatNullable<T>(){

            @Override
            public Float apply(T object) {
                return delegate.isNull(object) ? null : Float.valueOf(mapper.applyAsFloat(delegate.applyAsFloat(object)));
            }

            @Override
            public float applyAsFloat(T object) {
                return mapper.applyAsFloat(delegate.applyAsFloat(object));
            }

            @Override
            public ToFloat<T> orElseGet(ToFloat<T> getter) {
                return object -> delegate.isNull(object) ? getter.applyAsFloat(object) : mapper.applyAsFloat(delegate.applyAsFloat(object));
            }

            @Override
            public ToFloat<T> orElse(Float value) {
                return object -> delegate.isNull(object) ? value.floatValue() : mapper.applyAsFloat(delegate.applyAsFloat(object));
            }

            @Override
            public boolean isNull(T object) {
                return delegate.isNull(object);
            }

            @Override
            public boolean isNotNull(T object) {
                return delegate.isNotNull(object);
            }
        };
    }

    @Override
    default public long hash(T object) {
        if (this.isNull(object)) {
            return 0L;
        }
        float f = this.applyAsFloat(object);
        return f != 0.0f ? (long)Float.floatToIntBits(f) : 0L;
    }

    @Override
    default public int compare(T first, T second) {
        if (this.isNull(first)) {
            return this.isNull(second) ? 0 : 1;
        }
        if (this.isNull(second)) {
            return -1;
        }
        return Float.compare(this.applyAsFloat(first), this.applyAsFloat(second));
    }

    @Override
    default public <V> ToFloatNullable<V> compose(Function<? super V, ? extends T> before) {
        Function<? super V, ? extends T> casted = before;
        return ComposedUtil.composeToFloatNullable(casted, this);
    }
}

