/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute.internal;

import com.speedment.runtime.compute.ToString;
import com.speedment.runtime.compute.expression.JoiningExpression;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

public final class JoiningExpressionImpl<T>
implements JoiningExpression<T> {
    private final CharSequence separator;
    private final CharSequence prefix;
    private final CharSequence suffix;
    private final List<ToString<T>> expressions;

    public JoiningExpressionImpl(CharSequence separator, CharSequence prefix, CharSequence suffix, List<ToString<T>> expressions) {
        this.separator = Objects.requireNonNull(separator);
        this.prefix = Objects.requireNonNull(prefix);
        this.suffix = Objects.requireNonNull(suffix);
        this.expressions = Collections.unmodifiableList(expressions);
    }

    @Override
    public List<ToString<T>> expressions() {
        return this.expressions;
    }

    @Override
    public CharSequence prefix() {
        return this.prefix;
    }

    @Override
    public CharSequence suffix() {
        return this.suffix;
    }

    @Override
    public CharSequence separator() {
        return this.separator;
    }

    @Override
    public String apply(T object) {
        StringJoiner joiner = new StringJoiner(this.separator, this.prefix, this.suffix);
        for (ToString<T> expression : this.expressions) {
            joiner.add((CharSequence)expression.apply((Object)object));
        }
        return joiner.toString();
    }
}

