/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute.internal.expression;

import com.speedment.common.function.ToBooleanFunction;
import com.speedment.common.function.ToByteFunction;
import com.speedment.common.function.ToCharFunction;
import com.speedment.common.function.ToFloatFunction;
import com.speedment.common.function.ToShortFunction;
import com.speedment.runtime.compute.ToBigDecimal;
import com.speedment.runtime.compute.ToBigDecimalNullable;
import com.speedment.runtime.compute.ToBoolean;
import com.speedment.runtime.compute.ToBooleanNullable;
import com.speedment.runtime.compute.ToByte;
import com.speedment.runtime.compute.ToByteNullable;
import com.speedment.runtime.compute.ToChar;
import com.speedment.runtime.compute.ToCharNullable;
import com.speedment.runtime.compute.ToDouble;
import com.speedment.runtime.compute.ToDoubleNullable;
import com.speedment.runtime.compute.ToEnum;
import com.speedment.runtime.compute.ToEnumNullable;
import com.speedment.runtime.compute.ToFloat;
import com.speedment.runtime.compute.ToFloatNullable;
import com.speedment.runtime.compute.ToInt;
import com.speedment.runtime.compute.ToIntNullable;
import com.speedment.runtime.compute.ToLong;
import com.speedment.runtime.compute.ToLongNullable;
import com.speedment.runtime.compute.ToShort;
import com.speedment.runtime.compute.ToShortNullable;
import com.speedment.runtime.compute.ToString;
import com.speedment.runtime.compute.ToStringNullable;
import com.speedment.runtime.compute.expression.ComposedExpression;
import com.speedment.runtime.compute.expression.Expression;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;

public final class ComposedUtil {
    public static <T, A> ToByteNullable<T> composeToByte(Function<T, A> before, ToByte<A> after) {
        return new ComposeToByte<T, A, ToByte<A>>(before, after);
    }

    public static <T, A> ToByteNullable<T> composeToByteNullable(Function<T, A> before, ToByteNullable<A> after) {
        return new ComposeToByte<T, A, ToByteNullable<A>>(before, after);
    }

    public static <T, A> ToShortNullable<T> composeToShort(Function<T, A> before, ToShort<A> after) {
        return new ComposeToShort<T, A, ToShort<A>>(before, after);
    }

    public static <T, A> ToShortNullable<T> composeToShortNullable(Function<T, A> before, ToShortNullable<A> after) {
        return new ComposeToShort<T, A, ToShortNullable<A>>(before, after);
    }

    public static <T, A> ToIntNullable<T> composeToInt(Function<T, A> before, ToInt<A> after) {
        return new ComposeToInt<T, A, ToInt<A>>(before, after);
    }

    public static <T, A> ToIntNullable<T> composeToIntNullable(Function<T, A> before, ToIntNullable<A> after) {
        return new ComposeToInt<T, A, ToIntNullable<A>>(before, after);
    }

    public static <T, A> ToLongNullable<T> composeToLong(Function<T, A> before, ToLong<A> after) {
        return new ComposeToLong<T, A, ToLong<A>>(before, after);
    }

    public static <T, A> ToLongNullable<T> composeToLongNullable(Function<T, A> before, ToLongNullable<A> after) {
        return new ComposeToLong<T, A, ToLongNullable<A>>(before, after);
    }

    public static <T, A> ToFloatNullable<T> composeToFloat(Function<T, A> before, ToFloat<A> after) {
        return new ComposeToFloat<T, A, ToFloat<A>>(before, after);
    }

    public static <T, A> ToFloatNullable<T> composeToFloatNullable(Function<T, A> before, ToFloatNullable<A> after) {
        return new ComposeToFloat<T, A, ToFloatNullable<A>>(before, after);
    }

    public static <T, A> ToDoubleNullable<T> composeToDouble(Function<T, A> before, ToDouble<A> after) {
        return new ComposeToDouble<T, A, ToDouble<A>>(before, after);
    }

    public static <T, A> ToDoubleNullable<T> composeToDoubleNullable(Function<T, A> before, ToDoubleNullable<A> after) {
        return new ComposeToDouble<T, A, ToDoubleNullable<A>>(before, after);
    }

    public static <T, A> ToBoolean<T> composeToBoolean(Function<T, A> before, ToBoolean<A> after) {
        return new ComposeToBoolean<T, A, ToBoolean<A>>(before, after);
    }

    public static <T, A> ToBooleanNullable<T> composeToBooleanAsNullable(Function<T, A> before, ToBoolean<A> after) {
        return new ComposeToBooleanNullable<T, A, ToBoolean<A>>(before, after);
    }

    public static <T, A> ToBooleanNullable<T> composeToBooleanNullable(Function<T, A> before, ToBooleanNullable<A> after) {
        return new ComposeToBooleanNullable<T, A, ToBooleanNullable<A>>(before, after);
    }

    public static <T, A> ToCharNullable<T> composeToChar(Function<T, A> before, ToChar<A> after) {
        return new ComposeToChar<T, A, ToChar<A>>(before, after);
    }

    public static <T, A> ToCharNullable<T> composeToCharNullable(Function<T, A> before, ToCharNullable<A> after) {
        return new ComposeToChar<T, A, ToCharNullable<A>>(before, after);
    }

    public static <T, A> ToStringNullable<T> composeToString(Function<T, A> before, ToString<A> after) {
        return new ComposeToString<T, A, ToString<A>>(before, after);
    }

    public static <T, A> ToStringNullable<T> composeToStringNullable(Function<T, A> before, ToStringNullable<A> after) {
        return new ComposeToString<T, A, ToStringNullable<A>>(before, after);
    }

    public static <T, A> ToBigDecimalNullable<T> composeToBigDecimal(Function<T, A> before, ToBigDecimal<A> after) {
        return new ComposeToBigDecimal<T, A, ToBigDecimal<A>>(before, after);
    }

    public static <T, A> ToBigDecimalNullable<T> composeToBigDecimalNullable(Function<T, A> before, ToBigDecimalNullable<A> after) {
        return new ComposeToBigDecimal<T, A, ToBigDecimalNullable<A>>(before, after);
    }

    public static <T, A, E extends Enum<E>> ToEnumNullable<T, E> composeToEnum(Function<T, A> before, ToEnum<A, E> after) {
        return new ComposeToEnum<T, A, E, ToEnum<A, E>>(before, after, after.enumClass());
    }

    public static <T, A, E extends Enum<E>> ToEnumNullable<T, E> composeToEnumNullable(Function<T, A> before, ToEnumNullable<A, E> after) {
        return new ComposeToEnum<T, A, E, ToEnumNullable<A, E>>(before, after, after.enumClass());
    }

    private ComposedUtil() {
    }

    static final class ComposeToEnum<T, A, E extends Enum<E>, AFTER extends Function<A, E> & Expression<A>>
    implements ComposedExpression<T, A>,
    ToEnumNullable<T, E> {
        private final Function<T, A> before;
        private final AFTER after;
        private final Class<E> enumClass;

        ComposeToEnum(Function<T, A> before, AFTER after, Class<E> enumClass) {
            this.before = Objects.requireNonNull(before);
            this.after = (Function)Objects.requireNonNull(after);
            this.enumClass = Objects.requireNonNull(enumClass);
        }

        @Override
        public Class<E> enumClass() {
            return this.enumClass;
        }

        @Override
        public Function<T, A> firstStep() {
            return this.before;
        }

        public AFTER secondStep() {
            return this.after;
        }

        @Override
        public E apply(T object) {
            A intermediate = this.before.apply(object);
            if (intermediate == null) {
                return null;
            }
            return (E)((Enum)this.after.apply(intermediate));
        }
    }

    static final class ComposeToBigDecimal<T, A, AFTER extends Function<A, BigDecimal> & Expression<A>>
    implements ComposedExpression<T, A>,
    ToBigDecimalNullable<T> {
        private final Function<T, A> before;
        private final AFTER after;

        ComposeToBigDecimal(Function<T, A> before, AFTER after) {
            this.before = Objects.requireNonNull(before);
            this.after = (Function)Objects.requireNonNull(after);
        }

        @Override
        public Function<T, A> firstStep() {
            return this.before;
        }

        public AFTER secondStep() {
            return this.after;
        }

        @Override
        public BigDecimal apply(T object) {
            A intermediate = this.before.apply(object);
            if (intermediate == null) {
                return null;
            }
            return (BigDecimal)this.after.apply(intermediate);
        }
    }

    static final class ComposeToString<T, A, AFTER extends Function<A, String> & Expression<A>>
    implements ComposedExpression<T, A>,
    ToStringNullable<T> {
        private final Function<T, A> before;
        private final AFTER after;

        ComposeToString(Function<T, A> before, AFTER after) {
            this.before = Objects.requireNonNull(before);
            this.after = (Function)Objects.requireNonNull(after);
        }

        @Override
        public Function<T, A> firstStep() {
            return this.before;
        }

        public AFTER secondStep() {
            return this.after;
        }

        @Override
        public String apply(T object) {
            A intermediate = this.before.apply(object);
            if (intermediate == null) {
                return null;
            }
            return (String)this.after.apply(intermediate);
        }
    }

    static final class ComposeToChar<T, A, AFTER extends ToCharFunction<A> & Expression<A>>
    implements ComposedExpression<T, A>,
    ToCharNullable<T> {
        private final Function<T, A> before;
        private final AFTER after;

        ComposeToChar(Function<T, A> before, AFTER after) {
            this.before = Objects.requireNonNull(before);
            this.after = (ToCharFunction)Objects.requireNonNull(after);
        }

        @Override
        public Function<T, A> firstStep() {
            return this.before;
        }

        public AFTER secondStep() {
            return this.after;
        }

        @Override
        public char applyAsChar(T object) {
            A intermediate = this.before.apply(object);
            return this.after.applyAsChar(intermediate);
        }

        @Override
        public Character apply(T object) {
            A intermediate = this.before.apply(object);
            if (intermediate == null) {
                return null;
            }
            return Character.valueOf(this.after.applyAsChar(intermediate));
        }
    }

    static final class ComposeToBooleanNullable<T, A, AFTER extends ToBooleanFunction<A> & Expression<A>>
    implements ComposedExpression<T, A>,
    ToBooleanNullable<T> {
        private final Function<T, A> before;
        private final AFTER after;

        ComposeToBooleanNullable(Function<T, A> before, AFTER after) {
            this.before = Objects.requireNonNull(before);
            this.after = (ToBooleanFunction)Objects.requireNonNull(after);
        }

        @Override
        public Function<T, A> firstStep() {
            return this.before;
        }

        public AFTER secondStep() {
            return this.after;
        }

        @Override
        public boolean applyAsBoolean(T object) {
            A intermediate = this.before.apply(object);
            return this.after.applyAsBoolean(intermediate);
        }

        @Override
        public Boolean apply(T object) {
            A intermediate = this.before.apply(object);
            if (intermediate == null) {
                return null;
            }
            return this.after.applyAsBoolean(intermediate);
        }
    }

    static final class ComposeToBoolean<T, A, AFTER extends ToBooleanFunction<A> & Expression<A>>
    implements ComposedExpression<T, A>,
    ToBoolean<T> {
        private final Function<T, A> before;
        private final AFTER after;

        ComposeToBoolean(Function<T, A> before, AFTER after) {
            this.before = Objects.requireNonNull(before);
            this.after = (ToBooleanFunction)Objects.requireNonNull(after);
        }

        @Override
        public Function<T, A> firstStep() {
            return this.before;
        }

        public AFTER secondStep() {
            return this.after;
        }

        @Override
        public boolean applyAsBoolean(T object) {
            A intermediate = this.before.apply(object);
            return intermediate != null && this.after.applyAsBoolean(intermediate);
        }
    }

    static final class ComposeToDouble<T, A, AFTER extends ToDoubleFunction<A> & Expression<A>>
    implements ComposedExpression<T, A>,
    ToDoubleNullable<T> {
        private final Function<T, A> before;
        private final AFTER after;

        ComposeToDouble(Function<T, A> before, AFTER after) {
            this.before = Objects.requireNonNull(before);
            this.after = (ToDoubleFunction)Objects.requireNonNull(after);
        }

        @Override
        public Function<T, A> firstStep() {
            return this.before;
        }

        public AFTER secondStep() {
            return this.after;
        }

        @Override
        public double applyAsDouble(T object) {
            A intermediate = this.before.apply(object);
            return this.after.applyAsDouble(intermediate);
        }

        @Override
        public Double apply(T object) {
            A intermediate = this.before.apply(object);
            if (intermediate == null) {
                return null;
            }
            return this.after.applyAsDouble(intermediate);
        }
    }

    static final class ComposeToFloat<T, A, AFTER extends ToFloatFunction<A> & Expression<A>>
    implements ComposedExpression<T, A>,
    ToFloatNullable<T> {
        private final Function<T, A> before;
        private final AFTER after;

        ComposeToFloat(Function<T, A> before, AFTER after) {
            this.before = Objects.requireNonNull(before);
            this.after = (ToFloatFunction)Objects.requireNonNull(after);
        }

        @Override
        public Function<T, A> firstStep() {
            return this.before;
        }

        public AFTER secondStep() {
            return this.after;
        }

        @Override
        public float applyAsFloat(T object) {
            A intermediate = this.before.apply(object);
            return this.after.applyAsFloat(intermediate);
        }

        @Override
        public Float apply(T object) {
            A intermediate = this.before.apply(object);
            if (intermediate == null) {
                return null;
            }
            return Float.valueOf(this.after.applyAsFloat(intermediate));
        }
    }

    static final class ComposeToLong<T, A, AFTER extends ToLongFunction<A> & Expression<A>>
    implements ComposedExpression<T, A>,
    ToLongNullable<T> {
        private final Function<T, A> before;
        private final AFTER after;

        ComposeToLong(Function<T, A> before, AFTER after) {
            this.before = Objects.requireNonNull(before);
            this.after = (ToLongFunction)Objects.requireNonNull(after);
        }

        @Override
        public Function<T, A> firstStep() {
            return this.before;
        }

        public AFTER secondStep() {
            return this.after;
        }

        @Override
        public long applyAsLong(T object) {
            A intermediate = this.before.apply(object);
            return this.after.applyAsLong(intermediate);
        }

        @Override
        public Long apply(T object) {
            A intermediate = this.before.apply(object);
            if (intermediate == null) {
                return null;
            }
            return this.after.applyAsLong(intermediate);
        }
    }

    static final class ComposeToInt<T, A, AFTER extends ToIntFunction<A> & Expression<A>>
    implements ComposedExpression<T, A>,
    ToIntNullable<T> {
        private final Function<T, A> before;
        private final AFTER after;

        ComposeToInt(Function<T, A> before, AFTER after) {
            this.before = Objects.requireNonNull(before);
            this.after = (ToIntFunction)Objects.requireNonNull(after);
        }

        @Override
        public Function<T, A> firstStep() {
            return this.before;
        }

        public AFTER secondStep() {
            return this.after;
        }

        @Override
        public int applyAsInt(T object) {
            A intermediate = this.before.apply(object);
            return this.after.applyAsInt(intermediate);
        }

        @Override
        public Integer apply(T object) {
            A intermediate = this.before.apply(object);
            if (intermediate == null) {
                return null;
            }
            return this.after.applyAsInt(intermediate);
        }
    }

    static final class ComposeToShort<T, A, AFTER extends ToShortFunction<A> & Expression<A>>
    implements ComposedExpression<T, A>,
    ToShortNullable<T> {
        private final Function<T, A> before;
        private final AFTER after;

        ComposeToShort(Function<T, A> before, AFTER after) {
            this.before = Objects.requireNonNull(before);
            this.after = (ToShortFunction)Objects.requireNonNull(after);
        }

        @Override
        public Function<T, A> firstStep() {
            return this.before;
        }

        public AFTER secondStep() {
            return this.after;
        }

        @Override
        public short applyAsShort(T object) {
            A intermediate = this.before.apply(object);
            return this.after.applyAsShort(intermediate);
        }

        @Override
        public Short apply(T object) {
            A intermediate = this.before.apply(object);
            if (intermediate == null) {
                return null;
            }
            return this.after.applyAsShort(intermediate);
        }
    }

    static final class ComposeToByte<T, A, AFTER extends ToByteFunction<A> & Expression<A>>
    implements ComposedExpression<T, A>,
    ToByteNullable<T> {
        private final Function<T, A> before;
        private final AFTER after;

        ComposeToByte(Function<T, A> before, AFTER after) {
            this.before = Objects.requireNonNull(before);
            this.after = (ToByteFunction)Objects.requireNonNull(after);
        }

        @Override
        public Function<T, A> firstStep() {
            return this.before;
        }

        public AFTER secondStep() {
            return this.after;
        }

        @Override
        public byte applyAsByte(T object) {
            A intermediate = this.before.apply(object);
            return this.after.applyAsByte(intermediate);
        }

        @Override
        public Byte apply(T object) {
            A intermediate = this.before.apply(object);
            if (intermediate == null) {
                return null;
            }
            return this.after.applyAsByte(intermediate);
        }
    }
}

