/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute.internal.expression;

import com.speedment.runtime.compute.ToByte;
import com.speedment.runtime.compute.ToDouble;
import com.speedment.runtime.compute.ToFloat;
import com.speedment.runtime.compute.ToInt;
import com.speedment.runtime.compute.ToLong;
import com.speedment.runtime.compute.ToShort;
import com.speedment.runtime.compute.expression.BinaryExpression;
import com.speedment.runtime.compute.expression.BinaryObjExpression;
import com.speedment.runtime.compute.expression.Expression;
import java.util.Objects;

public final class DivideUtil {
    public static <T> ToDouble<T> byteDivideInt(ToByte<T> first, final int second) {
        return new DivideObjToDouble<T, ToByte<T>, Integer>(first){

            @Override
            public double applyAsDouble(T object) {
                return (double)((ToByte)this.first).applyAsByte(object) / (double)second;
            }

            @Override
            public Integer second() {
                return second;
            }
        };
    }

    public static <T> ToDouble<T> byteDivideLong(ToByte<T> first, final long second) {
        return new DivideObjToDouble<T, ToByte<T>, Long>(first){

            @Override
            public double applyAsDouble(T object) {
                return (double)((ToByte)this.first).applyAsByte(object) / (double)second;
            }

            @Override
            public Long second() {
                return second;
            }
        };
    }

    public static <T> ToDouble<T> byteDivideDouble(ToByte<T> first, final double second) {
        return new DivideObjToDouble<T, ToByte<T>, Double>(first){

            @Override
            public double applyAsDouble(T object) {
                return (double)((ToByte)this.first).applyAsByte(object) / second;
            }

            @Override
            public Double second() {
                return second;
            }
        };
    }

    public static <T> ToDouble<T> byteDivideInt(ToByte<T> first, ToInt<T> second) {
        return new DivideToDouble<T, ToByte<T>, ToInt<T>>(first, second){

            @Override
            public double applyAsDouble(T object) {
                return (double)((ToByte)this.first).applyAsByte(object) / (double)((ToInt)this.second).applyAsInt(object);
            }
        };
    }

    public static <T> ToDouble<T> byteDivideLong(ToByte<T> first, ToLong<T> second) {
        return new DivideToDouble<T, ToByte<T>, ToLong<T>>(first, second){

            @Override
            public double applyAsDouble(T object) {
                return (double)((ToByte)this.first).applyAsByte(object) / (double)((ToLong)this.second).applyAsLong(object);
            }
        };
    }

    public static <T> ToDouble<T> byteDivideDouble(ToByte<T> first, ToDouble<T> second) {
        return new DivideToDouble<T, ToByte<T>, ToDouble<T>>(first, second){

            @Override
            public double applyAsDouble(T object) {
                return (double)((ToByte)this.first).applyAsByte(object) / ((ToDouble)this.second).applyAsDouble(object);
            }
        };
    }

    public static <T> ToDouble<T> shortDivideInt(ToShort<T> first, final int second) {
        return new DivideObjToDouble<T, ToShort<T>, Integer>(first){

            @Override
            public double applyAsDouble(T object) {
                return (double)((ToShort)this.first).applyAsShort(object) / (double)second;
            }

            @Override
            public Integer second() {
                return second;
            }
        };
    }

    public static <T> ToDouble<T> shortDivideLong(ToShort<T> first, final long second) {
        return new DivideObjToDouble<T, ToShort<T>, Long>(first){

            @Override
            public double applyAsDouble(T object) {
                return (double)((ToShort)this.first).applyAsShort(object) / (double)second;
            }

            @Override
            public Long second() {
                return second;
            }
        };
    }

    public static <T> ToDouble<T> shortDivideDouble(ToShort<T> first, final double second) {
        return new DivideObjToDouble<T, ToShort<T>, Double>(first){

            @Override
            public double applyAsDouble(T object) {
                return (double)((ToShort)this.first).applyAsShort(object) / second;
            }

            @Override
            public Double second() {
                return second;
            }
        };
    }

    public static <T> ToDouble<T> shortDivideInt(ToShort<T> first, ToInt<T> second) {
        return new DivideToDouble<T, ToShort<T>, ToInt<T>>(first, second){

            @Override
            public double applyAsDouble(T object) {
                return (double)((ToShort)this.first).applyAsShort(object) / (double)((ToInt)this.second).applyAsInt(object);
            }
        };
    }

    public static <T> ToDouble<T> shortDivideLong(ToShort<T> first, ToLong<T> second) {
        return new DivideToDouble<T, ToShort<T>, ToLong<T>>(first, second){

            @Override
            public double applyAsDouble(T object) {
                return (double)((ToShort)this.first).applyAsShort(object) / (double)((ToLong)this.second).applyAsLong(object);
            }
        };
    }

    public static <T> ToDouble<T> shortDivideDouble(ToShort<T> first, ToDouble<T> second) {
        return new DivideToDouble<T, ToShort<T>, ToDouble<T>>(first, second){

            @Override
            public double applyAsDouble(T object) {
                return (double)((ToShort)this.first).applyAsShort(object) / ((ToDouble)this.second).applyAsDouble(object);
            }
        };
    }

    public static <T> ToDouble<T> intDivideInt(ToInt<T> first, final int second) {
        return new DivideObjToDouble<T, ToInt<T>, Integer>(first){

            @Override
            public double applyAsDouble(T object) {
                return (double)((ToInt)this.first).applyAsInt(object) / (double)second;
            }

            @Override
            public Integer second() {
                return second;
            }
        };
    }

    public static <T> ToDouble<T> intDivideLong(ToInt<T> first, final long second) {
        return new DivideObjToDouble<T, ToInt<T>, Long>(first){

            @Override
            public double applyAsDouble(T object) {
                return (double)((ToInt)this.first).applyAsInt(object) / (double)second;
            }

            @Override
            public Long second() {
                return second;
            }
        };
    }

    public static <T> ToDouble<T> intDivideDouble(ToInt<T> first, final double second) {
        return new DivideObjToDouble<T, ToInt<T>, Double>(first){

            @Override
            public double applyAsDouble(T object) {
                return (double)((ToInt)this.first).applyAsInt(object) / second;
            }

            @Override
            public Double second() {
                return second;
            }
        };
    }

    public static <T> ToDouble<T> intDivideInt(ToInt<T> first, ToInt<T> second) {
        return new DivideToDouble<T, ToInt<T>, ToInt<T>>(first, second){

            @Override
            public double applyAsDouble(T object) {
                return (double)((ToInt)this.first).applyAsInt(object) / (double)((ToInt)this.second).applyAsInt(object);
            }
        };
    }

    public static <T> ToDouble<T> intDivideLong(ToInt<T> first, ToLong<T> second) {
        return new DivideToDouble<T, ToInt<T>, ToLong<T>>(first, second){

            @Override
            public double applyAsDouble(T object) {
                return (double)((ToInt)this.first).applyAsInt(object) / (double)((ToLong)this.second).applyAsLong(object);
            }
        };
    }

    public static <T> ToDouble<T> intDivideDouble(ToInt<T> first, ToDouble<T> second) {
        return new DivideToDouble<T, ToInt<T>, ToDouble<T>>(first, second){

            @Override
            public double applyAsDouble(T object) {
                return (double)((ToInt)this.first).applyAsInt(object) / ((ToDouble)this.second).applyAsDouble(object);
            }
        };
    }

    public static <T> ToDouble<T> longDivideInt(ToLong<T> first, final int second) {
        return new DivideObjToDouble<T, ToLong<T>, Integer>(first){

            @Override
            public double applyAsDouble(T object) {
                return (double)((ToLong)this.first).applyAsLong(object) / (double)second;
            }

            @Override
            public Integer second() {
                return second;
            }
        };
    }

    public static <T> ToDouble<T> longDivideLong(ToLong<T> first, final long second) {
        return new DivideObjToDouble<T, ToLong<T>, Long>(first){

            @Override
            public double applyAsDouble(T object) {
                return (double)((ToLong)this.first).applyAsLong(object) / (double)second;
            }

            @Override
            public Long second() {
                return second;
            }
        };
    }

    public static <T> ToDouble<T> longDivideDouble(ToLong<T> first, final double second) {
        return new DivideObjToDouble<T, ToLong<T>, Double>(first){

            @Override
            public double applyAsDouble(T object) {
                return (double)((ToLong)this.first).applyAsLong(object) / second;
            }

            @Override
            public Double second() {
                return second;
            }
        };
    }

    public static <T> ToDouble<T> longDivideInt(ToLong<T> first, ToInt<T> second) {
        return new DivideToDouble<T, ToLong<T>, ToInt<T>>(first, second){

            @Override
            public double applyAsDouble(T object) {
                return (double)((ToLong)this.first).applyAsLong(object) / (double)((ToInt)this.second).applyAsInt(object);
            }
        };
    }

    public static <T> ToDouble<T> longDivideLong(ToLong<T> first, ToLong<T> second) {
        return new DivideToDouble<T, ToLong<T>, ToLong<T>>(first, second){

            @Override
            public double applyAsDouble(T object) {
                return (double)((ToLong)this.first).applyAsLong(object) / (double)((ToLong)this.second).applyAsLong(object);
            }
        };
    }

    public static <T> ToDouble<T> longDivideDouble(ToLong<T> first, ToDouble<T> second) {
        return new DivideToDouble<T, ToLong<T>, ToDouble<T>>(first, second){

            @Override
            public double applyAsDouble(T object) {
                return (double)((ToLong)this.first).applyAsLong(object) / ((ToDouble)this.second).applyAsDouble(object);
            }
        };
    }

    public static <T> ToDouble<T> floatDivideInt(ToFloat<T> first, final int second) {
        return new DivideObjToDouble<T, ToFloat<T>, Integer>(first){

            @Override
            public double applyAsDouble(T object) {
                return (double)((ToFloat)this.first).applyAsFloat(object) / (double)second;
            }

            @Override
            public Integer second() {
                return second;
            }
        };
    }

    public static <T> ToDouble<T> floatDivideLong(ToFloat<T> first, final long second) {
        return new DivideObjToDouble<T, ToFloat<T>, Long>(first){

            @Override
            public double applyAsDouble(T object) {
                return (double)((ToFloat)this.first).applyAsFloat(object) / (double)second;
            }

            @Override
            public Long second() {
                return second;
            }
        };
    }

    public static <T> ToDouble<T> floatDivideDouble(ToFloat<T> first, final double second) {
        return new DivideObjToDouble<T, ToFloat<T>, Double>(first){

            @Override
            public double applyAsDouble(T object) {
                return (double)((ToFloat)this.first).applyAsFloat(object) / second;
            }

            @Override
            public Double second() {
                return second;
            }
        };
    }

    public static <T> ToDouble<T> floatDivideInt(ToFloat<T> first, ToInt<T> second) {
        return new DivideToDouble<T, ToFloat<T>, ToInt<T>>(first, second){

            @Override
            public double applyAsDouble(T object) {
                return (double)((ToFloat)this.first).applyAsFloat(object) / (double)((ToInt)this.second).applyAsInt(object);
            }
        };
    }

    public static <T> ToDouble<T> floatDivideLong(ToFloat<T> first, ToLong<T> second) {
        return new DivideToDouble<T, ToFloat<T>, ToLong<T>>(first, second){

            @Override
            public double applyAsDouble(T object) {
                return (double)((ToFloat)this.first).applyAsFloat(object) / (double)((ToLong)this.second).applyAsLong(object);
            }
        };
    }

    public static <T> ToDouble<T> floatDivideDouble(ToFloat<T> first, ToDouble<T> second) {
        return new DivideToDouble<T, ToFloat<T>, ToDouble<T>>(first, second){

            @Override
            public double applyAsDouble(T object) {
                return (double)((ToFloat)this.first).applyAsFloat(object) / ((ToDouble)this.second).applyAsDouble(object);
            }
        };
    }

    public static <T> ToDouble<T> doubleDivideInt(ToDouble<T> first, final int second) {
        return new DivideObjToDouble<T, ToDouble<T>, Integer>(first){

            @Override
            public double applyAsDouble(T object) {
                return ((ToDouble)this.first).applyAsDouble(object) / (double)second;
            }

            @Override
            public Integer second() {
                return second;
            }
        };
    }

    public static <T> ToDouble<T> doubleDivideLong(ToDouble<T> first, final long second) {
        return new DivideObjToDouble<T, ToDouble<T>, Long>(first){

            @Override
            public double applyAsDouble(T object) {
                return ((ToDouble)this.first).applyAsDouble(object) / (double)second;
            }

            @Override
            public Long second() {
                return second;
            }
        };
    }

    public static <T> ToDouble<T> doubleDivideDouble(ToDouble<T> first, final double second) {
        return new DivideObjToDouble<T, ToDouble<T>, Double>(first){

            @Override
            public double applyAsDouble(T object) {
                return ((ToDouble)this.first).applyAsDouble(object) / second;
            }

            @Override
            public Double second() {
                return second;
            }
        };
    }

    public static <T> ToDouble<T> doubleDivideInt(ToDouble<T> first, ToInt<T> second) {
        return new DivideToDouble<T, ToDouble<T>, ToInt<T>>(first, second){

            @Override
            public double applyAsDouble(T object) {
                return ((ToDouble)this.first).applyAsDouble(object) / (double)((ToInt)this.second).applyAsInt(object);
            }
        };
    }

    public static <T> ToDouble<T> doubleDivideLong(ToDouble<T> first, ToLong<T> second) {
        return new DivideToDouble<T, ToDouble<T>, ToLong<T>>(first, second){

            @Override
            public double applyAsDouble(T object) {
                return ((ToDouble)this.first).applyAsDouble(object) / (double)((ToLong)this.second).applyAsLong(object);
            }
        };
    }

    public static <T> ToDouble<T> doubleDivideDouble(ToDouble<T> first, ToDouble<T> second) {
        return new DivideToDouble<T, ToDouble<T>, ToDouble<T>>(first, second){

            @Override
            public double applyAsDouble(T object) {
                return ((ToDouble)this.first).applyAsDouble(object) / ((ToDouble)this.second).applyAsDouble(object);
            }
        };
    }

    private DivideUtil() {
    }

    private static abstract class DivideObj<T, INNER extends Expression<T>, N>
    implements BinaryObjExpression<T, INNER, N> {
        final INNER first;

        DivideObj(INNER first) {
            this.first = (Expression)Objects.requireNonNull(first);
        }

        @Override
        public final INNER first() {
            return this.first;
        }
    }

    static abstract class DivideObjToDouble<T, INNER extends Expression<T>, N>
    extends DivideObj<T, INNER, N>
    implements ToDouble<T> {
        DivideObjToDouble(INNER first) {
            super(first);
        }

        @Override
        public BinaryObjExpression.Operator operator() {
            return BinaryObjExpression.Operator.DIVIDE;
        }

        @Override
        public final boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (!(o instanceof BinaryObjExpression)) {
                return false;
            }
            BinaryObjExpression that = (BinaryObjExpression)o;
            return Objects.equals(this.first, that.first()) && Objects.equals((Object)this.operator(), (Object)that.operator());
        }

        public final int hashCode() {
            return Objects.hash(new Object[]{this.first, this.second(), this.operator()});
        }
    }

    private static abstract class Divide<T, FIRST extends Expression<T>, SECOND extends Expression<T>>
    implements BinaryExpression<T, FIRST, SECOND> {
        final FIRST first;
        final SECOND second;

        Divide(FIRST first, SECOND second) {
            this.first = (Expression)Objects.requireNonNull(first);
            this.second = (Expression)Objects.requireNonNull(second);
        }

        @Override
        public FIRST first() {
            return this.first;
        }

        @Override
        public SECOND second() {
            return this.second;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BinaryExpression)) {
                return false;
            }
            BinaryExpression divide = (BinaryExpression)o;
            return Objects.equals(this.first(), divide.first()) && Objects.equals(this.second(), divide.second()) && Objects.equals((Object)this.operator(), (Object)divide.operator());
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.first(), this.second(), this.operator()});
        }
    }

    static abstract class DivideToDouble<T, FIRST extends Expression<T>, SECOND extends Expression<T>>
    extends Divide<T, FIRST, SECOND>
    implements ToDouble<T> {
        DivideToDouble(FIRST first, SECOND second) {
            super(first, second);
        }

        @Override
        public BinaryExpression.Operator operator() {
            return BinaryExpression.Operator.DIVIDE;
        }
    }
}

