/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.runtime.compute.internal.expression;

import com.speedment.runtime.compute.ToBigDecimal;
import com.speedment.runtime.compute.ToBoolean;
import com.speedment.runtime.compute.ToBooleanNullable;
import com.speedment.runtime.compute.ToByte;
import com.speedment.runtime.compute.ToByteNullable;
import com.speedment.runtime.compute.ToDouble;
import com.speedment.runtime.compute.ToDoubleNullable;
import com.speedment.runtime.compute.ToFloat;
import com.speedment.runtime.compute.ToFloatNullable;
import com.speedment.runtime.compute.ToInt;
import com.speedment.runtime.compute.ToIntNullable;
import com.speedment.runtime.compute.ToLong;
import com.speedment.runtime.compute.ToLongNullable;
import com.speedment.runtime.compute.ToShort;
import com.speedment.runtime.compute.ToShortNullable;
import com.speedment.runtime.compute.expression.Expression;
import com.speedment.runtime.compute.expression.UnaryExpression;
import com.speedment.runtime.compute.internal.ToBooleanNullableImpl;
import com.speedment.runtime.compute.internal.ToByteNullableImpl;
import com.speedment.runtime.compute.internal.ToDoubleNullableImpl;
import com.speedment.runtime.compute.internal.ToFloatNullableImpl;
import com.speedment.runtime.compute.internal.ToIntNullableImpl;
import com.speedment.runtime.compute.internal.ToLongNullableImpl;
import com.speedment.runtime.compute.internal.ToShortNullableImpl;
import java.math.BigDecimal;
import java.util.Objects;

public final class NegateUtil {
    private NegateUtil() {
    }

    public static <T> ToByte<T> negateByte(ToByte<T> expression) {
        class NegateByte
        extends AbstractNegate<T, ToByte<T>>
        implements ToByte<T> {
            NegateByte(ToByte<T> inner) {
                super(inner);
            }

            @Override
            public byte applyAsByte(T object) {
                return -((ToByte)this.inner).applyAsByte(object);
            }
        }
        return new NegateByte(expression);
    }

    public static <T> ToShort<T> negateShort(ToShort<T> expression) {
        class NegateShort
        extends AbstractNegate<T, ToShort<T>>
        implements ToShort<T> {
            NegateShort(ToShort<T> inner) {
                super(inner);
            }

            @Override
            public short applyAsShort(T object) {
                return -((ToShort)this.inner).applyAsShort(object);
            }
        }
        return new NegateShort(expression);
    }

    public static <T> ToInt<T> negateInt(ToInt<T> expression) {
        class NegateInt
        extends AbstractNegate<T, ToInt<T>>
        implements ToInt<T> {
            NegateInt(ToInt<T> inner) {
                super(inner);
            }

            @Override
            public int applyAsInt(T object) {
                return -((ToInt)this.inner).applyAsInt(object);
            }
        }
        return new NegateInt(expression);
    }

    public static <T> ToLong<T> negateLong(ToLong<T> expression) {
        class NegateLong
        extends AbstractNegate<T, ToLong<T>>
        implements ToLong<T> {
            NegateLong(ToLong<T> inner) {
                super(inner);
            }

            @Override
            public long applyAsLong(T object) {
                return -((ToLong)this.inner).applyAsLong(object);
            }
        }
        return new NegateLong(expression);
    }

    public static <T> ToFloat<T> negateFloat(ToFloat<T> expression) {
        class NegateFloat
        extends AbstractNegate<T, ToFloat<T>>
        implements ToFloat<T> {
            NegateFloat(ToFloat<T> inner) {
                super(inner);
            }

            @Override
            public float applyAsFloat(T object) {
                return -((ToFloat)this.inner).applyAsFloat(object);
            }
        }
        return new NegateFloat(expression);
    }

    public static <T> ToDouble<T> negateDouble(ToDouble<T> expression) {
        class NegateDouble
        extends AbstractNegate<T, ToDouble<T>>
        implements ToDouble<T> {
            NegateDouble(ToDouble<T> inner) {
                super(inner);
            }

            @Override
            public double applyAsDouble(T object) {
                return -((ToDouble)this.inner).applyAsDouble(object);
            }
        }
        return new NegateDouble(expression);
    }

    public static <T> ToBigDecimal<T> negateBigDecimal(ToBigDecimal<T> expression) {
        class NegateBigDecimal
        extends AbstractNegate<T, ToBigDecimal<T>>
        implements ToBigDecimal<T> {
            NegateBigDecimal(ToBigDecimal<T> inner) {
                super(inner);
            }

            @Override
            public BigDecimal apply(T object) {
                return ((BigDecimal)((ToBigDecimal)this.inner).apply(object)).negate();
            }
        }
        return new NegateBigDecimal(expression);
    }

    public static <T> ToBoolean<T> negateBoolean(ToBoolean<T> expression) {
        class NegateBoolean
        extends AbstractNegate<T, ToBoolean<T>>
        implements ToBoolean<T> {
            NegateBoolean(ToBoolean<T> inner) {
                super(inner);
            }

            @Override
            public boolean applyAsBoolean(T object) {
                return !((ToBoolean)this.inner).applyAsBoolean(object);
            }
        }
        return new NegateBoolean(expression);
    }

    public static <T> ToByteNullable<T> negateByteOrNull(ToByteNullable<T> expression) {
        return new ToByteNullableImpl<T>(NegateUtil.negateByte(expression.orThrow()), expression.isNull());
    }

    public static <T> ToShortNullable<T> negateShortOrNull(ToShortNullable<T> expression) {
        return new ToShortNullableImpl<T>(NegateUtil.negateShort(expression.orThrow()), expression.isNull());
    }

    public static <T> ToIntNullable<T> negateIntOrNull(ToIntNullable<T> expression) {
        return new ToIntNullableImpl<T>(NegateUtil.negateInt(expression.orThrow()), expression.isNull());
    }

    public static <T> ToLongNullable<T> negateLongOrNull(ToLongNullable<T> expression) {
        return new ToLongNullableImpl<T>(NegateUtil.negateLong(expression.orThrow()), expression.isNull());
    }

    public static <T> ToFloatNullable<T> negateFloatOrNull(ToFloatNullable<T> expression) {
        return new ToFloatNullableImpl<T>(NegateUtil.negateFloat(expression.orThrow()), expression.isNull());
    }

    public static <T> ToDoubleNullable<T> negateDoubleOrNull(ToDoubleNullable<T> expression) {
        return new ToDoubleNullableImpl<T>(NegateUtil.negateDouble(expression.orThrow()), expression.isNull());
    }

    public static <T> ToBooleanNullable<T> negateBooleanOrNull(ToBooleanNullable<T> expression) {
        return new ToBooleanNullableImpl<T>(NegateUtil.negateBoolean(expression.orThrow()), expression.isNull());
    }

    static abstract class AbstractNegate<T, INNER extends Expression<T>>
    implements UnaryExpression<T, INNER> {
        final INNER inner;

        AbstractNegate(INNER inner) {
            this.inner = (Expression)Objects.requireNonNull(inner);
        }

        @Override
        public final INNER inner() {
            return this.inner;
        }

        @Override
        public final UnaryExpression.Operator operator() {
            return UnaryExpression.Operator.NEGATE;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UnaryExpression)) {
                return false;
            }
            UnaryExpression that = (UnaryExpression)o;
            return Objects.equals(this.inner(), that.inner()) && this.operator() == that.operator();
        }

        public final int hashCode() {
            return Objects.hash(new Object[]{this.inner(), this.operator()});
        }
    }
}

