/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.configprovider;

import com.sun.faces.facelets.util.Classpath;
import com.sun.faces.spi.ConfigurationResourceProvider;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaInfFaceletTaglibraryConfigProvider
implements ConfigurationResourceProvider {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String SUFFIX = ".taglib.xml";
    private static final String[] FACELET_CONFIG_FILES = new String[]{"META-INF/jsf-core.taglib.xml", "META-INF/jsf-html.taglib.xml", "META-INF/jsf-ui.taglib.xml", "META-INF/jstl-core.taglib.xml", "META-INF/jstl-fn.taglib.xml"};

    @Override
    public Collection<URL> getResources(ServletContext context) {
        try {
            URL[] urls = Classpath.search(Util.getCurrentLoader(this), "META-INF/", SUFFIX);
            return this.pruneURLs(urls);
        }
        catch (IOException ioe) {
            throw new FacesException("Error searching classpath from facelet-taglib documents", (Throwable)ioe);
        }
    }

    private List<URL> pruneURLs(URL[] urls) {
        List<URL> ret = null;
        if (urls != null && urls.length > 0) {
            for (URL url : urls) {
                String u = url.toString();
                boolean found = false;
                for (String excludeName : FACELET_CONFIG_FILES) {
                    if (!u.contains(excludeName)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                if (ret == null) {
                    ret = new ArrayList<URL>();
                }
                ret.add(url);
            }
        }
        if (ret == null) {
            ret = Collections.emptyList();
        }
        return ret;
    }
}

