/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.tag.jsf;

import com.sun.faces.facelets.tag.AbstractTagLibrary;
import com.sun.faces.facelets.tag.TagLibraryImpl;
import com.sun.faces.facelets.tag.jsf.CompositeComponentTagHandler;
import com.sun.faces.util.FacesLogger;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.Resource;
import javax.faces.application.ResourceHandler;
import javax.faces.context.FacesContext;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;

public class CompositeComponentTagLibrary
extends TagLibraryImpl {
    private static final Logger LOGGER = FacesLogger.FACELETS_COMPONENT.getLogger();
    private String ns = null;
    private String compositeLibraryName;
    private static final String NS_COMPOSITE_COMPONENT_PREFIX = "http://java.sun.com/jsf/composite/";

    public CompositeComponentTagLibrary(String ns) {
        super(ns);
        if (null == ns) {
            throw new NullPointerException();
        }
        this.ns = ns;
    }

    public CompositeComponentTagLibrary(String ns, String compositeLibraryName) {
        super(ns);
        if (null == ns) {
            throw new NullPointerException();
        }
        this.ns = ns;
        if (null == compositeLibraryName) {
            throw new NullPointerException();
        }
        this.compositeLibraryName = compositeLibraryName;
    }

    public boolean containsTagHandler(String ns, String localName) {
        boolean result = false;
        Resource ccResource = null;
        ccResource = this.getCompositeComponentResource(ns, localName);
        if (null != ccResource) {
            InputStream componentStream;
            block3: {
                componentStream = null;
                try {
                    componentStream = ccResource.getInputStream();
                }
                catch (IOException ex) {
                    if (!LOGGER.isLoggable(Level.SEVERE)) break block3;
                    LOGGER.log(Level.SEVERE, ex.toString(), ex);
                }
            }
            result = componentStream != null || super.containsTagHandler(ns, localName);
        }
        return result;
    }

    private Resource getCompositeComponentResource(String ns, String localName) {
        Resource ccResource = null;
        if (ns.equals(this.ns)) {
            FacesContext context = FacesContext.getCurrentInstance();
            String libraryName = this.getCompositeComponentLibraryName(this.ns);
            if (null != libraryName) {
                String ccName = localName + ".xhtml";
                ResourceHandler resourceHandler = context.getApplication().getResourceHandler();
                ccResource = resourceHandler.createResource(ccName, libraryName);
            }
        }
        return ccResource;
    }

    public TagHandler createTagHandler(String ns, String localName, TagConfig tag) throws FacesException {
        Object result = super.createTagHandler(ns, localName, tag);
        if (result == null) {
            AbstractTagLibrary.ComponentConfigWrapper componentConfig = new AbstractTagLibrary.ComponentConfigWrapper(tag, "javax.faces.NamingContainer", null);
            result = new CompositeComponentTagHandler(this.getCompositeComponentResource(ns, localName), componentConfig);
        }
        return result;
    }

    public boolean tagLibraryForNSExists(String toTest) {
        boolean result = false;
        String resourceId = null;
        resourceId = this.getCompositeComponentLibraryName(toTest);
        if (null != resourceId) {
            result = FacesContext.getCurrentInstance().getApplication().getResourceHandler().libraryExists(resourceId);
        }
        return result;
    }

    public static boolean scriptComponentForResourceExists(FacesContext context, Resource componentResource) {
        boolean result;
        block2: {
            result = false;
            Resource scriptComponentResource = context.getApplication().getViewHandler().getViewDeclarationLanguage(context, context.getViewRoot().getViewId()).getScriptComponentResource(context, componentResource);
            try {
                result = null != scriptComponentResource && null != scriptComponentResource.getInputStream();
            }
            catch (IOException ex) {
                if (!LOGGER.isLoggable(Level.SEVERE)) break block2;
                LOGGER.log(Level.SEVERE, ex.toString(), ex);
            }
        }
        return result;
    }

    private String getCompositeComponentLibraryName(String toTest) {
        String resourceId = null;
        if (null != this.compositeLibraryName) {
            resourceId = this.compositeLibraryName;
        } else {
            int resourceIdIndex = toTest.indexOf(NS_COMPOSITE_COMPONENT_PREFIX);
            if (-1 != resourceIdIndex && (resourceIdIndex += NS_COMPOSITE_COMPONENT_PREFIX.length()) < toTest.length()) {
                resourceId = toTest.substring(resourceIdIndex);
            }
        }
        return resourceId;
    }
}

