/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.piggybank;

import com.twitter.elephantbird.pig.util.ThriftToPig;
import com.twitter.elephantbird.thrift.ThriftBinaryDeserializer;
import com.twitter.elephantbird.util.TypeRef;
import java.io.IOException;
import org.apache.pig.EvalFunc;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;

public abstract class BytesToThriftTuple<T extends TBase<?, ?>>
extends EvalFunc<Tuple> {
    private final TDeserializer deserializer_ = new ThriftBinaryDeserializer();
    private ThriftToPig<T> thriftToTuple_;
    private TypeRef<T> typeRef_;

    public void setTypeRef(TypeRef<T> typeRef) {
        this.typeRef_ = typeRef;
        this.thriftToTuple_ = ThriftToPig.newInstance(typeRef);
    }

    public Tuple exec(Tuple input) throws IOException {
        if (input == null || input.size() < 1) {
            return null;
        }
        try {
            TBase tObj = (TBase)this.typeRef_.safeNewInstance();
            DataByteArray dbarr = (DataByteArray)input.get(0);
            this.deserializer_.deserialize(tObj, dbarr.get());
            return this.thriftToTuple_.getPigTuple(tObj);
        }
        catch (IOException e) {
            this.log.warn((Object)("Caught exception " + e.getMessage()));
            return null;
        }
        catch (TException e) {
            this.log.warn((Object)("Unable to deserialize Thrift object: " + (Object)((Object)e)));
            return null;
        }
    }
}

