/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.store;

import com.twitter.elephantbird.pig.util.PigCounterHelper;
import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.pig.StoreFunc;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.impl.util.UDFContext;

public abstract class BaseStoreFunc
extends StoreFunc {
    private final PigCounterHelper counterHelper = new PigCounterHelper();
    protected RecordWriter writer;
    protected String contextSignature;

    protected void incrCounter(String group, String counter, long incr) {
        this.counterHelper.incrCounter(group, counter, incr);
    }

    protected void incrCounter(Enum<?> key, long incr) {
        this.counterHelper.incrCounter(key, incr);
    }

    protected void incrCounter(Pair<String, String> groupCounterPair, long incr) {
        this.counterHelper.incrCounter((String)groupCounterPair.first, (String)groupCounterPair.second, incr);
    }

    public void setStoreFuncUDFContextSignature(String signature) {
        this.contextSignature = signature;
    }

    protected Properties getUDFProperties() {
        return UDFContext.getUDFContext().getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.contextSignature});
    }

    public void prepareToWrite(RecordWriter writer) throws IOException {
        this.writer = writer;
    }

    public void setStoreLocation(String location, Job job) throws IOException {
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(location));
    }

    protected final void writeRecord(Object key, Object value) throws IOException {
        try {
            this.writer.write(key, value);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }
}

