/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import com.twitter.elephantbird.thrift.TStructDescriptor;
import com.twitter.elephantbird.util.ThriftUtils;
import com.twitter.elephantbird.util.TypeRef;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.thrift.TBase;
import org.apache.thrift.TEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PigToThrift<T extends TBase<?, ?>> {
    public static final Logger LOG = LoggerFactory.getLogger(PigToThrift.class);
    private TStructDescriptor structDesc;

    public static <T extends TBase<?, ?>> PigToThrift<T> newInstance(Class<T> tClass) {
        return new PigToThrift<T>(tClass);
    }

    public static <T extends TBase<?, ?>> PigToThrift<T> newInstance(TypeRef<T> typeRef) {
        return new PigToThrift<T>(typeRef.getRawClass());
    }

    public PigToThrift(Class<T> tClass) {
        this.structDesc = TStructDescriptor.getInstance(tClass);
    }

    public T getThriftObject(Tuple tuple) {
        return (T)PigToThrift.toThrift(this.structDesc, tuple);
    }

    private static TBase<?, ?> toThrift(TStructDescriptor tDesc, Tuple tuple) {
        int size = tDesc.getFields().size();
        int tupleSize = tuple.size();
        TBase<?, ?> tObj = PigToThrift.newTInstance(tDesc.getThriftClass());
        for (int i = 0; i < size && i < tupleSize; ++i) {
            Object pObj;
            try {
                pObj = tuple.get(i);
            }
            catch (ExecException e) {
                throw new RuntimeException(e);
            }
            if (pObj == null) continue;
            TStructDescriptor.Field field = tDesc.getFieldAt(i);
            try {
                tObj.setFieldValue(field.getFieldIdEnum(), PigToThrift.toThriftValue(field, pObj));
                continue;
            }
            catch (Exception e) {
                String value = String.valueOf(tObj);
                int max_length = 100;
                if (100 < value.length()) {
                    value = value.substring(0, 97) + "...";
                }
                String type = tObj == null ? "unknown" : tObj.getClass().getName();
                throw new RuntimeException(String.format("Failed to set field '%s' using tuple value '%s' of type '%s' at index %d", field.getName(), value, type, i), e);
            }
        }
        return tObj;
    }

    public static Object toThriftValue(TStructDescriptor.Field thriftField, Object pigValue) {
        try {
            switch (thriftField.getType()) {
                case 2: {
                    return (Integer)pigValue != 0;
                }
                case 3: {
                    return ((Integer)pigValue).byteValue();
                }
                case 6: {
                    return ((Integer)pigValue).shortValue();
                }
                case 11: {
                    return PigToThrift.toStringType(pigValue);
                }
                case 12: {
                    return PigToThrift.toThrift(thriftField.gettStructDescriptor(), (Tuple)pigValue);
                }
                case 13: {
                    return PigToThrift.toThriftMap(thriftField, (Map)pigValue);
                }
                case 14: {
                    return PigToThrift.toThriftSet(thriftField.getSetElemField(), (DataBag)pigValue);
                }
                case 15: {
                    return PigToThrift.toThriftList(thriftField.getListElemField(), (DataBag)pigValue);
                }
                case 16: {
                    return PigToThrift.toThriftEnum(thriftField, (String)pigValue);
                }
            }
            return pigValue;
        }
        catch (Exception e) {
            LOG.warn(String.format("Failed to set field '%s' of type '%s' with value '%s' of type '%s'", thriftField.getName(), ThriftUtils.getFieldValueType((TStructDescriptor.Field)thriftField).getName(), pigValue, pigValue.getClass().getName()), (Throwable)e);
            return null;
        }
    }

    private static Object toStringType(Object value) {
        if (value instanceof String) {
            return value;
        }
        if (value instanceof DataByteArray) {
            byte[] buf = ((DataByteArray)value).get();
            return ByteBuffer.wrap(Arrays.copyOf(buf, buf.length));
        }
        return null;
    }

    private static Map<Object, Object> toThriftMap(TStructDescriptor.Field field, Map<String, Object> map) {
        TStructDescriptor.Field keyField = field.getMapKeyField();
        TStructDescriptor.Field valueField = field.getMapValueField();
        if (keyField.getType() != 11 && keyField.getType() != 16) {
            throw new IllegalArgumentException("TStructs's map key should be a STRING or an ENUM");
        }
        HashMap<Object, Object> out = new HashMap<Object, Object>(map.size());
        for (Map.Entry<String, Object> e : map.entrySet()) {
            out.put(PigToThrift.toThriftValue(keyField, e.getKey()), PigToThrift.toThriftValue(valueField, e.getValue()));
        }
        return out;
    }

    private static Set<Object> toThriftSet(TStructDescriptor.Field elemField, DataBag bag) {
        HashSet<Object> set = new HashSet<Object>((int)bag.size());
        PigToThrift.fillThriftCollection(set, elemField, bag);
        return set;
    }

    private static List<Object> toThriftList(TStructDescriptor.Field elemField, DataBag bag) {
        ArrayList<Object> list = new ArrayList<Object>((int)bag.size());
        PigToThrift.fillThriftCollection(list, elemField, bag);
        return list;
    }

    private static TEnum toThriftEnum(TStructDescriptor.Field elemField, String name) {
        TEnum out = elemField.getEnumValueOf(name);
        if (out == null) {
            throw new IllegalArgumentException(String.format("Failed to convert string '%s' to enum value of type '%s'", name, ThriftUtils.getFieldValueType((TStructDescriptor.Field)elemField).getName()));
        }
        return out;
    }

    private static void fillThriftCollection(Collection<Object> tColl, TStructDescriptor.Field elemField, DataBag bag) {
        for (Tuple tuple : bag) {
            if (!elemField.isStruct()) {
                try {
                    tColl.add(PigToThrift.toThriftValue(elemField, tuple.get(0)));
                    continue;
                }
                catch (ExecException e) {
                    throw new RuntimeException(e);
                }
            }
            tColl.add(PigToThrift.toThriftValue(elemField, tuple));
        }
    }

    private static TBase<?, ?> newTInstance(Class<?> tClass) {
        try {
            return (TBase)tClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

