/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.Writable;
import org.apache.pig.LoadCaster;
import org.apache.pig.ResourceSchema;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.joda.time.DateTime;

public abstract class WritableLoadCaster<W extends Writable>
implements LoadCaster {
    private final DataInputBuffer buf = new DataInputBuffer();
    protected W writable;

    public WritableLoadCaster(W writable) {
        this.writable = writable;
    }

    public WritableLoadCaster() {
    }

    protected <T extends Writable> T readFields(byte[] bytes, T writable) throws IOException {
        Preconditions.checkNotNull((Object)bytes, (Object)"Input bytes are null");
        Preconditions.checkNotNull(writable, (Object)"Writable is null");
        this.buf.reset(bytes, bytes.length);
        writable.readFields((DataInput)this.buf);
        return writable;
    }

    public String bytesToCharArray(byte[] bytes) throws IOException {
        this.writable = this.readFields(bytes, (Writable)this.writable);
        return this.toCharArray(this.writable);
    }

    public Boolean bytesToBoolean(byte[] bytes) throws IOException {
        this.writable = this.readFields(bytes, (Writable)this.writable);
        return this.toBoolean(this.writable);
    }

    public Integer bytesToInteger(byte[] bytes) throws IOException {
        this.writable = this.readFields(bytes, (Writable)this.writable);
        return this.toInteger(this.writable);
    }

    public Long bytesToLong(byte[] bytes) throws IOException {
        this.writable = this.readFields(bytes, (Writable)this.writable);
        return this.toLong(this.writable);
    }

    public Float bytesToFloat(byte[] bytes) throws IOException {
        this.writable = this.readFields(bytes, (Writable)this.writable);
        return this.toFloat(this.writable);
    }

    public Double bytesToDouble(byte[] bytes) throws IOException {
        this.writable = this.readFields(bytes, (Writable)this.writable);
        return this.toDouble(this.writable);
    }

    public Map<String, Object> bytesToMap(byte[] bytes) throws IOException {
        this.writable = this.readFields(bytes, (Writable)this.writable);
        return this.toMap(this.writable);
    }

    public Map<String, Object> bytesToMap(byte[] bytes, ResourceSchema.ResourceFieldSchema schema) throws IOException {
        this.writable = this.readFields(bytes, (Writable)this.writable);
        return this.toMap(this.writable, schema);
    }

    public Tuple bytesToTuple(byte[] bytes, ResourceSchema.ResourceFieldSchema schema) throws IOException {
        this.writable = this.readFields(bytes, (Writable)this.writable);
        return this.toTuple(this.writable, schema);
    }

    public DataBag bytesToBag(byte[] bytes, ResourceSchema.ResourceFieldSchema schema) throws IOException {
        this.writable = this.readFields(bytes, (Writable)this.writable);
        return this.toBag(this.writable, schema);
    }

    public DateTime bytesToDateTime(byte[] bytes) throws IOException {
        this.writable = this.readFields(bytes, (Writable)this.writable);
        return this.toDateTime(this.writable);
    }

    protected String toCharArray(W writable) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected Boolean toBoolean(W writable) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected Integer toInteger(W writable) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected Long toLong(W writable) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected Float toFloat(W writable) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected Double toDouble(W writable) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected Map<String, Object> toMap(W writable) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected Map<String, Object> toMap(W writable, ResourceSchema.ResourceFieldSchema schema) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected Tuple toTuple(W writable, ResourceSchema.ResourceFieldSchema schema) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected DataBag toBag(W writable, ResourceSchema.ResourceFieldSchema schema) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected DateTime toDateTime(W writable) throws IOException {
        throw new UnsupportedOperationException();
    }
}

