/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.pig.util;

import com.google.common.collect.Maps;
import com.twitter.elephantbird.util.HadoopCompat;
import java.util.Map;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.pig.impl.util.Pair;
import org.apache.pig.tools.pigstats.PigStatusReporter;

public class PigCounterHelper {
    private final Map<Pair<String, String>, Long> counterStringMap_ = Maps.newHashMap();
    private final Map<Enum<?>, Long> counterEnumMap_ = Maps.newHashMap();

    public void incrCounter(String group, String counterName, long incr) {
        Pair key;
        Counter counter;
        PigStatusReporter reporter = PigStatusReporter.getInstance();
        if (reporter != null && (counter = reporter.getCounter(group, counterName)) != null) {
            HadoopCompat.incrementCounter((Counter)counter, (long)incr);
            if (this.counterStringMap_.size() > 0) {
                for (Map.Entry<Pair<String, String>, Long> entry : this.counterStringMap_.entrySet()) {
                    HadoopCompat.incrementCounter((Counter)reporter.getCounter((String)entry.getKey().first, (String)entry.getKey().second), (long)entry.getValue());
                }
                this.counterStringMap_.clear();
            }
            return;
        }
        Long currentValue = this.counterStringMap_.get(key = new Pair((Object)group, (Object)counterName));
        this.counterStringMap_.put((Pair<String, String>)key, (currentValue == null ? 0L : currentValue) + incr);
    }

    public void incrCounter(Enum<?> key, long incr) {
        PigStatusReporter reporter = PigStatusReporter.getInstance();
        if (reporter != null && reporter.getCounter(key) != null) {
            HadoopCompat.incrementCounter((Counter)reporter.getCounter(key), (long)incr);
            if (this.counterEnumMap_.size() > 0) {
                for (Map.Entry<Enum<?>, Long> entry : this.counterEnumMap_.entrySet()) {
                    HadoopCompat.incrementCounter((Counter)reporter.getCounter(entry.getKey()), (long)entry.getValue());
                }
                this.counterEnumMap_.clear();
            }
        } else {
            Long currentValue = this.counterEnumMap_.get(key);
            this.counterEnumMap_.put(key, (currentValue == null ? 0L : currentValue) + incr);
        }
    }
}

