/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.provider;

import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.provider.ConfigurableFilterDataProvider;
import com.vaadin.flow.data.provider.ConfigurableFilterDataProviderWrapper;
import com.vaadin.flow.data.provider.DataProviderListener;
import com.vaadin.flow.data.provider.DataProviderWrapper;
import com.vaadin.flow.data.provider.FilterUtils;
import com.vaadin.flow.data.provider.ListDataProvider;
import com.vaadin.flow.data.provider.Query;
import com.vaadin.flow.function.SerializableBiFunction;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface DataProvider<T, F>
extends Serializable {
    public boolean isInMemory();

    public int size(Query<T, F> var1);

    public Stream<T> fetch(Query<T, F> var1);

    public void refreshItem(T var1);

    default public void refreshItem(T item, boolean refreshChildren) {
        this.refreshItem(item);
    }

    public void refreshAll();

    default public Object getId(T item) {
        Objects.requireNonNull(item, "Cannot provide an id for a null item.");
        return item;
    }

    public Registration addDataProviderListener(DataProviderListener<T> var1);

    default public <C> DataProvider<T, C> withConvertedFilter(final SerializableFunction<C, F> filterConverter) {
        Objects.requireNonNull(filterConverter, "Filter converter can't be null");
        return new DataProviderWrapper<T, C, F>(this){

            @Override
            protected F getFilter(Query<T, C> query) {
                return FilterUtils.convertFilter(filterConverter, query);
            }
        };
    }

    default public <Q, C> ConfigurableFilterDataProvider<T, Q, C> withConfigurableFilter(final SerializableBiFunction<Q, C, F> filterCombiner) {
        return new ConfigurableFilterDataProviderWrapper<T, Q, C, F>(this){

            @Override
            protected F combineFilters(Q queryFilter, C configuredFilter) {
                return FilterUtils.combineFilters(filterCombiner, queryFilter, configuredFilter);
            }
        };
    }

    default public ConfigurableFilterDataProvider<T, Void, F> withConfigurableFilter() {
        return this.withConfigurableFilter((SerializableBiFunction & Serializable)(queryFilter, configuredFilter) -> {
            if (!3.$assertionsDisabled && queryFilter != null) {
                throw new AssertionError((Object)"Filter from Void query must be null");
            }
            return configuredFilter;
        });
    }

    public static <T> ListDataProvider<T> ofCollection(Collection<T> items) {
        return new ListDataProvider<T>(items);
    }

    @SafeVarargs
    public static <T> ListDataProvider<T> ofItems(T ... items) {
        return new ListDataProvider<T>(new ArrayList<T>(Arrays.asList(items)));
    }

    public static <T> ListDataProvider<T> fromStream(Stream<T> items) {
        return new ListDataProvider(items.collect(Collectors.toList()));
    }

    public static <T, F> CallbackDataProvider<T, F> fromFilteringCallbacks(CallbackDataProvider.FetchCallback<T, F> fetchCallback, CallbackDataProvider.CountCallback<T, F> countCallback) {
        return new CallbackDataProvider<T, F>(fetchCallback, countCallback);
    }

    public static <T> CallbackDataProvider<T, Void> fromCallbacks(CallbackDataProvider.FetchCallback<T, Void> fetchCallback, CallbackDataProvider.CountCallback<T, Void> countCallback) {
        return DataProvider.fromFilteringCallbacks(fetchCallback, countCallback);
    }

    static {
        if (3.$assertionsDisabled) {
            // empty if block
        }
    }
}

