/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.charts.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.vaadin.flow.component.charts.model.AbstractConfigurationObject;
import com.vaadin.flow.component.charts.model.AbstractPlotOptions;
import com.vaadin.flow.component.charts.model.Configuration;
import com.vaadin.flow.component.charts.model.Series;
import com.vaadin.flow.component.charts.model.YAxis;

public abstract class AbstractSeries
extends AbstractConfigurationObject
implements Series {
    private String name;
    private String stack;
    private String id;
    @JsonUnwrapped
    private AbstractPlotOptions plotOptions;
    private Boolean visible;
    @JsonIgnore
    private Configuration configuration;
    private Integer xAxis;
    private Integer yAxis;
    private Integer colorAxis;

    public AbstractSeries() {
    }

    public AbstractSeries(String name) {
        this.setName(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public String getStack() {
        return this.stack;
    }

    public void setStack(String stack) {
        this.stack = stack;
    }

    @Override
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    @JsonIgnoreProperties
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Override
    public AbstractPlotOptions getPlotOptions() {
        return this.plotOptions;
    }

    @Override
    public void setPlotOptions(AbstractPlotOptions plotOptions) {
        this.plotOptions = plotOptions;
    }

    public void setVisible(Boolean visible) {
        this.setVisible(visible, true);
    }

    public void setVisible(Boolean visible, boolean updateChartImmediately) {
        boolean doDynamicChange = updateChartImmediately && this.getConfiguration() != null && this.visible != visible;
        this.visible = visible;
        if (doDynamicChange) {
            this.getConfiguration().fireSeriesEnabled(this, visible);
        }
    }

    public Boolean isVisible() {
        if (this.visible == null) {
            return Boolean.TRUE;
        }
        return this.visible;
    }

    public Integer getxAxis() {
        return this.xAxis;
    }

    public void setxAxis(Integer xAxis) {
        this.xAxis = xAxis;
    }

    public Integer getyAxis() {
        return this.yAxis;
    }

    public void setyAxis(Integer yAxis) {
        this.yAxis = yAxis;
    }

    public Integer getColorAxis() {
        return this.colorAxis;
    }

    public void setColorAxis(Integer colorAxis) {
        this.colorAxis = colorAxis;
    }

    public void setyAxis(YAxis secondaryAxis) {
        if (this.configuration == null) {
            throw new IllegalStateException("This method must be called only when series is attached to configuration options");
        }
        int indexOf = this.configuration.getyAxes().indexOf(secondaryAxis);
        if (indexOf == -1) {
            throw new IllegalStateException("This method can only be used if axis is already attached to the same configuration object");
        }
        this.setyAxis(indexOf);
    }

    public void updateSeries() {
        if (this.getConfiguration() != null) {
            this.getConfiguration().fireSeriesChanged(this);
        }
    }
}

