/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.sidenav.testbench;

import com.vaadin.testbench.TestBenchElement;
import com.vaadin.testbench.commands.TestBenchCommandExecutor;
import com.vaadin.testbench.elementsbase.Element;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openqa.selenium.By;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebElement;

@Element(value="vaadin-side-nav-item")
public class SideNavItemElement
extends TestBenchElement {
    public List<SideNavItemElement> getItems() {
        return this.getItems(false);
    }

    public List<SideNavItemElement> getItems(boolean includeNestedItems) {
        return this.getItemsStream(includeNestedItems).collect(Collectors.toList());
    }

    public String getLabel() {
        WebElement unnamedSlot = this.getWrappedElement().getShadowRoot().findElement(By.cssSelector((String)"slot:not([name])"));
        return (String)this.executeScript("return arguments[0].assignedNodes().map(node => {  return (node.nodeType === Node.TEXT_NODE) ? node.textContent.trim() : ''}).filter(Boolean).join(' ')", new Object[]{unnamedSlot});
    }

    public String getPath() {
        return this.getDomAttribute("path");
    }

    public boolean isExpanded() {
        return this.hasAttribute("expanded");
    }

    public boolean isCurrent() {
        return this.hasAttribute("current");
    }

    public void click() {
        this.click(1, 1, new Keys[0]);
    }

    public void navigate() {
        WebElement anchorElement;
        try {
            anchorElement = this.getWrappedElement().getShadowRoot().findElement(By.cssSelector((String)"a"));
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException("Item does not contain an anchor", (Throwable)e);
        }
        this.executeScript("arguments[0].click();", new Object[]{anchorElement});
    }

    public void toggle() {
        WebElement toggleButtonElement;
        try {
            toggleButtonElement = this.getWrappedElement().getShadowRoot().findElement(By.cssSelector((String)"button[part='toggle-button']"));
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException("Item does not contain a toggle button", (Throwable)e);
        }
        this.executeScript("arguments[0].click();", new Object[]{toggleButtonElement});
    }

    private Stream<SideNavItemElement> getItemsStream(boolean includeChildren) {
        String xpathExp = includeChildren ? ".//vaadin-side-nav-item" : "vaadin-side-nav-item";
        return SideNavItemElement.wrapElements((List)this.findElements(By.xpath((String)xpathExp)), (TestBenchCommandExecutor)this.getCommandExecutor()).stream().map(testBenchElement -> (SideNavItemElement)testBenchElement.wrap(SideNavItemElement.class));
    }
}

