/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.testbench;

import com.vaadin.testbench.parallel.Browser;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.http.ClientConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parameters {
    private static boolean isDebug;
    private static boolean isScreenshotComparisonCursorDetection;
    private static String screenshotReferenceDirectory;
    private static String screenshotErrorDirectory;
    private static double screenshotComparisonTolerance;
    private static int maxScreenshotRetries;
    private static int screenshotRetryDelay;
    private static int testsInParallel;
    private static int testSuitesInParallel;
    private static int maxAttempts;
    private static String testbenchGridBrowsers;
    private static boolean headless;
    private static int readTimeout;
    private static int hubPort;
    private static String[] chromeOptions;

    public static void setDebug(boolean isDebug) {
        Parameters.isDebug = isDebug;
    }

    private static boolean hasSystemProperty(String unqualifiedName) {
        return System.getProperty(Parameters.getQualifiedParameter(unqualifiedName)) != null;
    }

    private static String getSystemPropertyString(String unqualifiedName, String defaultValue) {
        if (Parameters.hasSystemProperty(unqualifiedName)) {
            return System.getProperty(Parameters.getQualifiedParameter(unqualifiedName));
        }
        return defaultValue;
    }

    private static boolean getSystemPropertyBoolean(String unqualifiedName, boolean defaultValue) {
        if (Parameters.hasSystemProperty(unqualifiedName)) {
            String str = System.getProperty(Parameters.getQualifiedParameter(unqualifiedName));
            return str != null && str.equalsIgnoreCase("true");
        }
        return defaultValue;
    }

    private static int getSystemPropertyInt(String unqualifiedName, int defaultValue) {
        if (Parameters.hasSystemProperty(unqualifiedName)) {
            String str = System.getProperty(Parameters.getQualifiedParameter(unqualifiedName));
            try {
                return Integer.parseInt(str);
            }
            catch (Exception e) {
                Parameters.getLogger().error("Unable to parse parameter '" + Parameters.getQualifiedParameter(unqualifiedName) + "' value " + str + " to an integer");
            }
        }
        return defaultValue;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(Parameters.class);
    }

    private static double getSystemPropertyDouble(String unqualifiedName, double defaultValue) {
        if (Parameters.hasSystemProperty(unqualifiedName)) {
            String str = System.getProperty(Parameters.getQualifiedParameter(unqualifiedName));
            try {
                return Double.parseDouble(str);
            }
            catch (Exception e) {
                Parameters.getLogger().error("Unable to parse parameter '" + Parameters.getQualifiedParameter(unqualifiedName) + "' value " + str + " to a double");
            }
        }
        return defaultValue;
    }

    private static String getQualifiedParameter(String unqualifiedName) {
        return Parameters.class.getName() + "." + unqualifiedName;
    }

    public static boolean isDebug() {
        return isDebug;
    }

    public static void setScreenshotComparisonCursorDetection(boolean isScreenshotComparisonCursorDetection) {
        Parameters.isScreenshotComparisonCursorDetection = isScreenshotComparisonCursorDetection;
    }

    public static boolean isScreenshotComparisonCursorDetection() {
        return isScreenshotComparisonCursorDetection;
    }

    public static void setScreenshotReferenceDirectory(String screenshotReferenceDirectory) {
        Parameters.screenshotReferenceDirectory = screenshotReferenceDirectory;
    }

    public static String getScreenshotReferenceDirectory() {
        return screenshotReferenceDirectory;
    }

    public static void setScreenshotErrorDirectory(String screenshotErrorDirectory) {
        Parameters.screenshotErrorDirectory = screenshotErrorDirectory;
    }

    public static String getScreenshotErrorDirectory() {
        return screenshotErrorDirectory;
    }

    public static void setScreenshotComparisonTolerance(double tolerance) {
        screenshotComparisonTolerance = tolerance;
    }

    public static double getScreenshotComparisonTolerance() {
        return screenshotComparisonTolerance;
    }

    public static void setMaxScreenshotRetries(int maxRetries) {
        maxScreenshotRetries = maxRetries;
    }

    public static int getMaxScreenshotRetries() {
        return maxScreenshotRetries;
    }

    public static void setScreenshotRetryDelay(int retryDelay) {
        screenshotRetryDelay = retryDelay;
    }

    public static int getScreenshotRetryDelay() {
        return screenshotRetryDelay;
    }

    public static void setTestsInParallel(int testsInParallel) {
        Parameters.testsInParallel = testsInParallel;
    }

    public static int getTestsInParallel() {
        return testsInParallel;
    }

    public static void setTestSuitesInParallel(int testSuitesInParallel) {
        Parameters.testSuitesInParallel = testSuitesInParallel;
    }

    public static int getTestSuitesInParallel() {
        return testSuitesInParallel;
    }

    public static String getHubHostname() {
        return Parameters.getSystemPropertyString("hubHostname", null);
    }

    public static int getHubPort() {
        return hubPort;
    }

    public static void setHubPort(int port) {
        hubPort = port;
    }

    public static String getRunLocallyBrowserName() {
        String browserAndVersion = Parameters.getSystemPropertyString("runLocally", null);
        if (browserAndVersion == null) {
            return null;
        }
        return Parameters.parseRunLocally(browserAndVersion)[0];
    }

    public static String getRunLocallyBrowserVersion() {
        String browserAndVersion = Parameters.getSystemPropertyString("runLocally", null);
        if (browserAndVersion == null) {
            return null;
        }
        return Parameters.parseRunLocally(browserAndVersion)[1];
    }

    static String[] parseRunLocally(String browserAndVersion) {
        if (browserAndVersion.contains("-")) {
            return browserAndVersion.split("-", 2);
        }
        return new String[]{browserAndVersion, ""};
    }

    public static boolean isLocalWebDriverUsed() {
        String useLocalWebDriver = System.getProperty("useLocalWebDriver");
        return useLocalWebDriver != null && useLocalWebDriver.toLowerCase().equals("true");
    }

    public static int getMaxAttempts() {
        return maxAttempts;
    }

    public static void setMaxAttempts(int maxAttempts) {
        Parameters.maxAttempts = maxAttempts;
    }

    public static String getGridBrowsersString() {
        return testbenchGridBrowsers;
    }

    public static List<DesiredCapabilities> getGridBrowsers() {
        String browsers = testbenchGridBrowsers;
        ArrayList<DesiredCapabilities> finalList = new ArrayList<DesiredCapabilities>();
        if (browsers != null && !browsers.isEmpty()) {
            for (String browserStr : browsers.split(",")) {
                String[] browserStrSplit = browserStr.split("-");
                Browser browser = Browser.valueOf(browserStrSplit[0].toUpperCase(Locale.ENGLISH).trim());
                DesiredCapabilities capabilities = browser.getDesiredCapabilities();
                if (browserStrSplit.length > 1) {
                    capabilities.setVersion(browserStrSplit[1].trim());
                }
                finalList.add(capabilities);
            }
        }
        return finalList;
    }

    public static void setGridBrowsers(String browsers) {
        testbenchGridBrowsers = browsers;
    }

    public static boolean isHeadless() {
        return headless;
    }

    public static void setHeadless(boolean headless) {
        Parameters.headless = headless;
    }

    public static void setReadTimeout(int readTimeout) {
        Parameters.readTimeout = readTimeout;
    }

    public static void setChromeOptions(String options) {
        chromeOptions = options == null || options.isBlank() ? new String[]{} : options.trim().split("[,\\s]+(?=--)");
    }

    public static String[] getChromeOptions() {
        return chromeOptions;
    }

    public static int getReadTimeout() {
        return readTimeout;
    }

    static {
        screenshotRetryDelay = 500;
        isDebug = Parameters.getSystemPropertyBoolean("debug", false);
        isScreenshotComparisonCursorDetection = Parameters.getSystemPropertyBoolean("screenshotComparisonCursorDetection", false);
        screenshotReferenceDirectory = Parameters.getSystemPropertyString("screenshotReferenceDirectory", "reference-screenshots");
        screenshotErrorDirectory = Parameters.getSystemPropertyString("screenshotErrorDirectory", "error-screenshots");
        screenshotComparisonTolerance = Parameters.getSystemPropertyDouble("screenshotComparisonTolerance", 0.01);
        maxScreenshotRetries = Parameters.getSystemPropertyInt("maxScreenshotRetries", 2);
        screenshotRetryDelay = Parameters.getSystemPropertyInt("screenshotRetryDelay", 500);
        testSuitesInParallel = Parameters.getSystemPropertyInt("testSuitesInParallel", 20);
        maxAttempts = Parameters.getSystemPropertyInt("maxAttempts", 1);
        testsInParallel = Parameters.hasSystemProperty("testsInParallel") ? Parameters.getSystemPropertyInt("testsInParallel", 1) : (Parameters.isLocalWebDriverUsed() ? 10 : 50);
        testbenchGridBrowsers = Parameters.getSystemPropertyString("gridBrowsers", System.getenv("TESTBENCH_GRID_BROWSERS"));
        headless = Parameters.getSystemPropertyBoolean("headless", false);
        readTimeout = Parameters.getSystemPropertyInt("readTimeout", (int)ClientConfig.defaultConfig().readTimeout().toSeconds());
        hubPort = Parameters.getSystemPropertyInt("hubPort", 4444);
        Parameters.setChromeOptions(Parameters.getSystemPropertyString("chromeOptions", null));
    }
}

