/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.datepicker;

import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.testbench.unit.ComponentTester;
import com.vaadin.testbench.unit.Tests;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.LocalDate;

@Tests(value={DatePicker.class})
public class DatePickerTester<T extends DatePicker>
extends ComponentTester<T> {
    public DatePickerTester(T component) {
        super(component);
    }

    public void setValue(LocalDate date) {
        this.ensureComponentIsUsable();
        Method isInvalid = this.getMethod("isInvalid", LocalDate.class);
        try {
            if (((Boolean)isInvalid.invoke(this.getComponent(), date)).booleanValue()) {
                throw new IllegalArgumentException("Given date is not a valid value");
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        ((DatePicker)this.getComponent()).setValue((Object)date);
    }
}

