/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.aggregation.stage;

import de.bwaldvogel.mongo.backend.Missing;
import de.bwaldvogel.mongo.backend.aggregation.Expression;
import de.bwaldvogel.mongo.backend.aggregation.stage.AggregationStage;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.MongoServerError;
import java.util.Map;
import java.util.stream.Stream;

public class AddFieldsStage
implements AggregationStage {
    private final Document addFields;

    public AddFieldsStage(Document addFields) {
        if (addFields.isEmpty()) {
            throw new MongoServerError(40177, "Invalid $addFields :: caused by :: specification must have at least one field");
        }
        this.addFields = addFields;
    }

    @Override
    public String name() {
        return "$addFields";
    }

    @Override
    public Stream<Document> apply(Stream<Document> stream) {
        return stream.map(this::projectDocument);
    }

    Document projectDocument(Document document) {
        Document clone = document.clone();
        this.putRecursively(clone, this.addFields);
        return clone;
    }

    private void putRecursively(Document target, Document source) {
        for (Map.Entry<String, Object> entry : source.entrySet()) {
            String key = entry.getKey();
            Object value = Expression.evaluateDocument(entry.getValue(), target);
            if (value instanceof Document) {
                Document subDocument = (Document)target.compute(key, (k, oldValue) -> {
                    if (!(oldValue instanceof Document)) {
                        return new Document();
                    }
                    return oldValue;
                });
                this.putRecursively(subDocument, (Document)value);
                continue;
            }
            if (value instanceof Missing) {
                target.remove(key);
                continue;
            }
            target.put(key, value);
        }
    }
}

