/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.oplog;

import de.bwaldvogel.mongo.MongoBackend;
import de.bwaldvogel.mongo.MongoCollection;
import de.bwaldvogel.mongo.backend.Cursor;
import de.bwaldvogel.mongo.backend.CursorRegistry;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.backend.aggregation.Aggregation;
import de.bwaldvogel.mongo.bson.BsonTimestamp;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.MongoServerException;
import de.bwaldvogel.mongo.oplog.InvalidateOplogCursor;
import de.bwaldvogel.mongo.oplog.OperationType;
import de.bwaldvogel.mongo.oplog.Oplog;
import de.bwaldvogel.mongo.oplog.OplogClock;
import de.bwaldvogel.mongo.oplog.OplogCursor;
import de.bwaldvogel.mongo.oplog.OplogPosition;
import java.util.List;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Stream;

public class CollectionBackedOplog
implements Oplog {
    private static final long ELECTION_TERM = 1L;
    private static final String START_AT_OPERATION_TIME = "startAtOperationTime";
    private static final String FULL_DOCUMENT = "fullDocument";
    private static final String START_AFTER = "startAfter";
    private static final String RESUME_AFTER = "resumeAfter";
    private static final String OPERATION_TYPE = "operationType";
    private static final String CLUSTER_TIME = "clusterTime";
    private static final String DOCUMENT_KEY = "documentKey";
    private final OplogClock oplogClock;
    private final MongoCollection<Document> collection;
    private final MongoBackend backend;
    private final CursorRegistry cursorRegistry;
    private final UUID ui = UUID.randomUUID();

    public CollectionBackedOplog(MongoBackend backend, MongoCollection<Document> collection, CursorRegistry cursorRegistry) {
        this.oplogClock = new OplogClock(backend.getClock());
        this.collection = collection;
        this.backend = backend;
        this.cursorRegistry = cursorRegistry;
    }

    @Override
    public void handleInsert(String namespace, List<Document> documents) {
        if (this.isOplogCollection(namespace)) {
            return;
        }
        Stream<Document> oplogInsertDocuments = documents.stream().map(document -> this.toOplogInsertDocument(namespace, (Document)document));
        this.addDocuments(oplogInsertDocuments);
    }

    @Override
    public void handleUpdate(String namespace, Document selector, Document query, List<Object> modifiedIds) {
        if (this.isOplogCollection(namespace)) {
            return;
        }
        Stream<Document> oplogUpdateDocuments = modifiedIds.stream().map(id -> this.toOplogUpdateDocument(namespace, query, id));
        this.addDocuments(oplogUpdateDocuments);
    }

    @Override
    public void handleDelete(String namespace, Document query, List<Object> deletedIds) {
        if (this.isOplogCollection(namespace)) {
            return;
        }
        Stream<Document> oplogDeleteDocuments = deletedIds.stream().map(id -> this.toOplogDeleteDocument(namespace, id));
        this.addDocuments(oplogDeleteDocuments);
    }

    private void addDocuments(Stream<Document> oplogDocuments) {
        this.collection.addDocuments(oplogDocuments);
    }

    @Override
    public void handleDropCollection(String namespace) {
        if (this.isOplogCollection(namespace)) {
            return;
        }
        String databaseName = Utils.getDatabaseNameFromFullName(namespace);
        String collectionName = Utils.getCollectionNameFromFullName(namespace);
        this.collection.addDocument(this.toOplogDropCollection(databaseName, collectionName));
    }

    private Stream<Document> streamOplog(Document changeStreamDocument, OplogPosition position, Aggregation aggregation, String namespace) {
        return aggregation.runStagesAsStream(this.collection.queryAllAsStream().filter(document -> CollectionBackedOplog.filterNamespace(document, namespace)).filter(document -> {
            BsonTimestamp timestamp = CollectionBackedOplog.getOplogTimestamp(document);
            OplogPosition documentOplogPosition = new OplogPosition(timestamp);
            return documentOplogPosition.isAfter(position);
        }).sorted((o1, o2) -> {
            BsonTimestamp timestamp1 = CollectionBackedOplog.getOplogTimestamp(o1);
            BsonTimestamp timestamp2 = CollectionBackedOplog.getOplogTimestamp(o2);
            return timestamp1.compareTo(timestamp2);
        }).map(document -> this.toChangeStreamResponseDocument((Document)document, changeStreamDocument)));
    }

    private static boolean filterNamespace(Document document, String namespace) {
        String docNS = (String)document.get("ns");
        if (docNS.equals(namespace)) {
            return true;
        }
        return Utils.getDatabaseNameFromFullName(namespace).equals(Utils.getDatabaseNameFromFullName(docNS)) && Utils.getCollectionNameFromFullName(docNS).equals("$cmd");
    }

    @Override
    public Cursor createCursor(Document changeStreamDocument, String namespace, Aggregation aggregation) {
        OplogPosition initialOplogPosition;
        Document startAfter = (Document)changeStreamDocument.get(START_AFTER);
        Document resumeAfter = (Document)changeStreamDocument.get(RESUME_AFTER);
        BsonTimestamp startAtOperationTime = (BsonTimestamp)changeStreamDocument.get(START_AT_OPERATION_TIME);
        if (startAfter != null) {
            initialOplogPosition = OplogPosition.fromDocument(startAfter);
        } else if (resumeAfter != null) {
            initialOplogPosition = OplogPosition.fromDocument(resumeAfter);
            String databaseName = Utils.getDatabaseNameFromFullName(namespace);
            String collectionName = Utils.getCollectionNameFromFullName(namespace);
            boolean resumeAfterTerminalEvent = this.collection.queryAllAsStream().filter(document -> {
                BsonTimestamp timestamp = CollectionBackedOplog.getOplogTimestamp(document);
                OplogPosition documentOplogPosition = new OplogPosition(timestamp);
                return initialOplogPosition.isAfter(documentOplogPosition.inclusive());
            }).anyMatch(document -> document.get("op").equals(OperationType.COMMAND.getCode()) && document.get("ns").equals(String.format("%s.$cmd", databaseName)) && document.get("o").equals(new Document("drop", collectionName)));
            if (resumeAfterTerminalEvent) {
                return new InvalidateOplogCursor(initialOplogPosition);
            }
        } else {
            initialOplogPosition = startAtOperationTime != null ? new OplogPosition(startAtOperationTime).inclusive() : new OplogPosition(this.oplogClock.now());
        }
        Function<OplogPosition, Stream<Document>> streamSupplier = position -> this.streamOplog(changeStreamDocument, (OplogPosition)position, aggregation, namespace);
        OplogCursor cursor = new OplogCursor(this.cursorRegistry.generateCursorId(), streamSupplier, initialOplogPosition);
        this.cursorRegistry.add(cursor);
        return cursor;
    }

    private Document toOplogDocument(OperationType operationType, String namespace) {
        return new Document().append("ts", this.oplogClock.incrementAndGet()).append("t", 1L).append("h", 0L).append("v", 2L).append("op", operationType.getCode()).append("ns", namespace).append("ui", this.ui).append("wall", this.oplogClock.instant());
    }

    private Document toOplogInsertDocument(String namespace, Document document) {
        return this.toOplogDocument(OperationType.INSERT, namespace).append("o", document.cloneDeeply());
    }

    private Document toOplogUpdateDocument(String namespace, Document query, Object id) {
        return this.toOplogDocument(OperationType.UPDATE, namespace).append("o", query).append("o2", new Document("_id", id));
    }

    private Document toOplogDeleteDocument(String namespace, Object deletedDocumentId) {
        return this.toOplogDocument(OperationType.DELETE, namespace).append("o", new Document("_id", deletedDocumentId));
    }

    private Document toOplogDropCollection(String databaseName, String collectionName) {
        return this.toOplogDocument(OperationType.COMMAND, String.format("%s.$cmd", databaseName)).append("o", new Document("drop", collectionName));
    }

    private boolean isOplogCollection(String namespace) {
        return this.collection.getFullName().equals(namespace);
    }

    private Document getFullDocument(Document changeStreamDocument, Document document, OperationType operationType) {
        switch (operationType) {
            case INSERT: {
                return CollectionBackedOplog.getUpdateDocument(document);
            }
            case DELETE: {
                return null;
            }
            case UPDATE: {
                return this.lookUpUpdateDocument(changeStreamDocument, document);
            }
        }
        throw new IllegalArgumentException("Invalid operation type");
    }

    private Document lookUpUpdateDocument(Document changeStreamDocument, Document document) {
        Document deltaUpdate = this.getDeltaUpdate(CollectionBackedOplog.getUpdateDocument(document));
        if (changeStreamDocument.containsKey(FULL_DOCUMENT) && changeStreamDocument.get(FULL_DOCUMENT).equals("updateLookup")) {
            String namespace = (String)document.get("ns");
            String databaseName = namespace.split("\\.")[0];
            String collectionName = namespace.split("\\.")[1];
            return this.backend.resolveDatabase(databaseName).resolveCollection(collectionName, true).queryAllAsStream().filter(d -> d.get("_id").equals(((Document)document.get("o2")).get("_id"))).findFirst().orElse(deltaUpdate);
        }
        return deltaUpdate;
    }

    private Document getDeltaUpdate(Document updateDocument) {
        Document delta = new Document();
        if (updateDocument.containsKey("$set")) {
            delta.appendAll((Document)updateDocument.get("$set"));
        }
        if (updateDocument.containsKey("$unset")) {
            delta.appendAll((Document)updateDocument.get("$unset"));
        }
        return delta;
    }

    private Document toChangeStreamResponseDocument(Document oplogDocument, Document changeStreamDocument) {
        OperationType operationType = OperationType.fromCode(oplogDocument.get("op").toString());
        Document documentKey = new Document();
        Document document = CollectionBackedOplog.getUpdateDocument(oplogDocument);
        BsonTimestamp timestamp = CollectionBackedOplog.getOplogTimestamp(oplogDocument);
        OplogPosition oplogPosition = new OplogPosition(timestamp);
        switch (operationType) {
            case DELETE: 
            case UPDATE: {
                documentKey = document;
                break;
            }
            case INSERT: {
                documentKey.append("_id", document.get("_id"));
                break;
            }
            case COMMAND: {
                return this.toChangeStreamCommandResponseDocument(oplogDocument, oplogPosition, timestamp);
            }
            default: {
                throw new IllegalArgumentException("Unexpected operation type: " + String.valueOf((Object)operationType));
            }
        }
        return new Document().append("_id", new Document("_data", oplogPosition.toHexString())).append(OPERATION_TYPE, operationType.getDescription()).append(FULL_DOCUMENT, this.getFullDocument(changeStreamDocument, oplogDocument, operationType)).append(DOCUMENT_KEY, documentKey).append(CLUSTER_TIME, timestamp);
    }

    private Document toChangeStreamCommandResponseDocument(Document oplogDocument, OplogPosition oplogPosition, BsonTimestamp timestamp) {
        Document document = CollectionBackedOplog.getUpdateDocument(oplogDocument);
        String operationType = (String)document.keySet().stream().findFirst().orElseThrow(() -> new MongoServerException("Unspecified command operation type"));
        return new Document().append("_id", new Document("_data", oplogPosition.toHexString())).append(OPERATION_TYPE, operationType).append(CLUSTER_TIME, timestamp);
    }

    private static BsonTimestamp getOplogTimestamp(Document document) {
        return (BsonTimestamp)document.get("ts");
    }

    private static Document getUpdateDocument(Document document) {
        return (Document)document.get("o");
    }
}

