/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.oplog;

import de.bwaldvogel.mongo.backend.Assert;
import java.util.HashMap;
import java.util.Map;

public enum OperationType {
    DELETE("d"),
    UPDATE("u"),
    INSERT("i"),
    COMMAND("c"),
    INVALIDATE("invalidate");

    private final String code;
    private static final Map<String, OperationType> MAP;

    private OperationType(String code) {
        this.code = code;
    }

    public String getCode() {
        return this.code;
    }

    static OperationType fromCode(String code) {
        OperationType operationType = MAP.get(code);
        if (operationType == null) {
            throw new IllegalArgumentException("unknown operation type: " + code);
        }
        return operationType;
    }

    String getDescription() {
        switch (this.ordinal()) {
            case 0: {
                return "delete";
            }
            case 2: {
                return "insert";
            }
            case 1: {
                return "update";
            }
            case 3: {
                return "command";
            }
            case 4: {
                return "invalidate";
            }
        }
        return null;
    }

    static {
        MAP = new HashMap<String, OperationType>();
        for (OperationType operationType : OperationType.values()) {
            OperationType old = MAP.put(operationType.getCode(), operationType);
            Assert.isNull((Object)old, () -> "Duplicate operation type value: " + operationType.getCode());
        }
    }
}

