/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openai;

import dev.ai4j.openai4j.chat.AssistantMessage;
import dev.ai4j.openai4j.chat.ChatCompletionChoice;
import dev.ai4j.openai4j.chat.ChatCompletionRequest;
import dev.ai4j.openai4j.chat.ChatCompletionResponse;
import dev.ai4j.openai4j.chat.Content;
import dev.ai4j.openai4j.chat.ContentType;
import dev.ai4j.openai4j.chat.Function;
import dev.ai4j.openai4j.chat.FunctionCall;
import dev.ai4j.openai4j.chat.FunctionMessage;
import dev.ai4j.openai4j.chat.ImageDetail;
import dev.ai4j.openai4j.chat.ImageUrl;
import dev.ai4j.openai4j.chat.JsonBooleanSchema;
import dev.ai4j.openai4j.chat.JsonEnumSchema;
import dev.ai4j.openai4j.chat.JsonObjectSchema;
import dev.ai4j.openai4j.chat.JsonStringSchema;
import dev.ai4j.openai4j.chat.Message;
import dev.ai4j.openai4j.chat.ResponseFormatType;
import dev.ai4j.openai4j.chat.Tool;
import dev.ai4j.openai4j.chat.ToolCall;
import dev.ai4j.openai4j.chat.ToolChoiceMode;
import dev.ai4j.openai4j.chat.ToolMessage;
import dev.ai4j.openai4j.chat.ToolType;
import dev.ai4j.openai4j.chat.UserMessage;
import dev.ai4j.openai4j.shared.CompletionTokensDetails;
import dev.ai4j.openai4j.shared.PromptTokensDetails;
import dev.ai4j.openai4j.shared.Usage;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolParameters;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.image.Image;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ImageContent;
import dev.langchain4j.data.message.SystemMessage;
import dev.langchain4j.data.message.TextContent;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.exception.UnsupportedFeatureException;
import dev.langchain4j.internal.Exceptions;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.StreamingResponseHandler;
import dev.langchain4j.model.chat.listener.ChatModelRequest;
import dev.langchain4j.model.chat.listener.ChatModelResponse;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.ResponseFormat;
import dev.langchain4j.model.chat.request.ToolChoice;
import dev.langchain4j.model.chat.request.json.JsonAnyOfSchema;
import dev.langchain4j.model.chat.request.json.JsonArraySchema;
import dev.langchain4j.model.chat.request.json.JsonIntegerSchema;
import dev.langchain4j.model.chat.request.json.JsonNumberSchema;
import dev.langchain4j.model.chat.request.json.JsonReferenceSchema;
import dev.langchain4j.model.chat.request.json.JsonSchema;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.model.openai.OpenAiTokenUsage;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.Response;
import dev.langchain4j.model.output.TokenUsage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class InternalOpenAiHelper {
    static final String OPENAI_URL = "https://api.openai.com/v1";
    static final String OPENAI_DEMO_API_KEY = "demo";
    static final String OPENAI_DEMO_URL = "http://langchain4j.dev/demo/openai/v1";
    static final String DEFAULT_USER_AGENT = "langchain4j-openai";

    public static List<Message> toOpenAiMessages(List<ChatMessage> messages) {
        return messages.stream().map(InternalOpenAiHelper::toOpenAiMessage).collect(Collectors.toList());
    }

    public static Message toOpenAiMessage(ChatMessage message) {
        if (message instanceof SystemMessage) {
            return dev.ai4j.openai4j.chat.SystemMessage.from((String)((SystemMessage)message).text());
        }
        if (message instanceof dev.langchain4j.data.message.UserMessage) {
            dev.langchain4j.data.message.UserMessage userMessage = (dev.langchain4j.data.message.UserMessage)message;
            if (userMessage.hasSingleText()) {
                return UserMessage.builder().content(userMessage.text()).name(userMessage.name()).build();
            }
            return UserMessage.builder().content(userMessage.contents().stream().map(InternalOpenAiHelper::toOpenAiContent).collect(Collectors.toList())).name(userMessage.name()).build();
        }
        if (message instanceof AiMessage) {
            AiMessage aiMessage = (AiMessage)message;
            if (!aiMessage.hasToolExecutionRequests()) {
                return AssistantMessage.from((String)aiMessage.text());
            }
            ToolExecutionRequest toolExecutionRequest = (ToolExecutionRequest)aiMessage.toolExecutionRequests().get(0);
            if (toolExecutionRequest.id() == null) {
                FunctionCall functionCall = FunctionCall.builder().name(toolExecutionRequest.name()).arguments(toolExecutionRequest.arguments()).build();
                return AssistantMessage.builder().functionCall(functionCall).build();
            }
            List toolCalls = aiMessage.toolExecutionRequests().stream().map(it -> ToolCall.builder().id(it.id()).type(ToolType.FUNCTION).function(FunctionCall.builder().name(it.name()).arguments(it.arguments()).build()).build()).collect(Collectors.toList());
            return AssistantMessage.builder().content(aiMessage.text()).toolCalls(toolCalls).build();
        }
        if (message instanceof ToolExecutionResultMessage) {
            ToolExecutionResultMessage toolExecutionResultMessage = (ToolExecutionResultMessage)message;
            if (toolExecutionResultMessage.id() == null) {
                return FunctionMessage.from((String)toolExecutionResultMessage.toolName(), (String)toolExecutionResultMessage.text());
            }
            return ToolMessage.from((String)toolExecutionResultMessage.id(), (String)toolExecutionResultMessage.text());
        }
        throw Exceptions.illegalArgument((String)("Unknown message type: " + String.valueOf(message.type())), (Object[])new Object[0]);
    }

    private static Content toOpenAiContent(dev.langchain4j.data.message.Content content) {
        if (content instanceof TextContent) {
            return InternalOpenAiHelper.toOpenAiContent((TextContent)content);
        }
        if (content instanceof ImageContent) {
            return InternalOpenAiHelper.toOpenAiContent((ImageContent)content);
        }
        throw Exceptions.illegalArgument((String)("Unknown content type: " + String.valueOf(content)), (Object[])new Object[0]);
    }

    private static Content toOpenAiContent(TextContent content) {
        return Content.builder().type(ContentType.TEXT).text(content.text()).build();
    }

    private static Content toOpenAiContent(ImageContent content) {
        return Content.builder().type(ContentType.IMAGE_URL).imageUrl(ImageUrl.builder().url(InternalOpenAiHelper.toUrl(content.image())).detail(InternalOpenAiHelper.toDetail(content.detailLevel())).build()).build();
    }

    private static String toUrl(Image image) {
        if (image.url() != null) {
            return image.url().toString();
        }
        return String.format("data:%s;base64,%s", image.mimeType(), image.base64Data());
    }

    private static ImageDetail toDetail(ImageContent.DetailLevel detailLevel) {
        if (detailLevel == null) {
            return null;
        }
        return ImageDetail.valueOf((String)detailLevel.name());
    }

    public static List<Tool> toTools(Collection<ToolSpecification> toolSpecifications, boolean strict) {
        if (toolSpecifications == null) {
            return null;
        }
        return toolSpecifications.stream().map(toolSpecification -> InternalOpenAiHelper.toTool(toolSpecification, strict)).collect(Collectors.toList());
    }

    private static Tool toTool(ToolSpecification toolSpecification, boolean strict) {
        Function.Builder functionBuilder = Function.builder().name(toolSpecification.name()).description(toolSpecification.description()).parameters(InternalOpenAiHelper.toOpenAiParameters(toolSpecification, strict));
        if (strict) {
            functionBuilder.strict(Boolean.valueOf(true));
        }
        Function function = functionBuilder.build();
        return Tool.from((Function)function);
    }

    @Deprecated
    public static List<Function> toFunctions(Collection<ToolSpecification> toolSpecifications) {
        return toolSpecifications.stream().map(InternalOpenAiHelper::toFunction).collect(Collectors.toList());
    }

    @Deprecated
    private static Function toFunction(ToolSpecification toolSpecification) {
        return Function.builder().name(toolSpecification.name()).description(toolSpecification.description()).parameters(InternalOpenAiHelper.toOpenAiParameters(toolSpecification, false)).build();
    }

    private static JsonObjectSchema toOpenAiParameters(ToolSpecification toolSpecification, boolean strict) {
        dev.langchain4j.model.chat.request.json.JsonObjectSchema parameters = toolSpecification.parameters();
        if (parameters != null) {
            JsonObjectSchema.Builder builder = JsonObjectSchema.builder().properties(InternalOpenAiHelper.toOpenAiProperties(parameters.properties(), strict)).required(parameters.required()).definitions(InternalOpenAiHelper.toOpenAiProperties(parameters.definitions(), strict));
            if (strict) {
                builder.required(new ArrayList(parameters.properties().keySet())).additionalProperties(Boolean.valueOf(false));
            }
            return builder.build();
        }
        ToolParameters toolParameters = toolSpecification.toolParameters();
        if (toolParameters == null) {
            JsonObjectSchema.Builder builder = JsonObjectSchema.builder();
            if (strict) {
                builder.additionalProperties(Boolean.valueOf(false));
            }
            return builder.build();
        }
        JsonObjectSchema.Builder builder = JsonObjectSchema.builder().properties(InternalOpenAiHelper.toOpenAiPropertiesOld(toolParameters.properties(), strict)).required(toolParameters.required());
        if (strict) {
            builder.required(new ArrayList(toolParameters.properties().keySet())).additionalProperties(Boolean.valueOf(false));
        }
        return builder.build();
    }

    private static Map<String, dev.ai4j.openai4j.chat.JsonSchemaElement> toOpenAiProperties(Map<String, JsonSchemaElement> properties, boolean strict) {
        if (properties == null) {
            return null;
        }
        LinkedHashMap<String, dev.ai4j.openai4j.chat.JsonSchemaElement> openAiProperties = new LinkedHashMap<String, dev.ai4j.openai4j.chat.JsonSchemaElement>();
        properties.forEach((key, value) -> openAiProperties.put((String)key, InternalOpenAiHelper.toOpenAiJsonSchemaElement(value, strict)));
        return openAiProperties;
    }

    private static dev.ai4j.openai4j.chat.JsonSchemaElement toOpenAiJsonSchemaElement(JsonSchemaElement jsonSchemaElement, boolean strict) {
        if (jsonSchemaElement instanceof dev.langchain4j.model.chat.request.json.JsonObjectSchema) {
            dev.langchain4j.model.chat.request.json.JsonObjectSchema jsonObjectSchema = (dev.langchain4j.model.chat.request.json.JsonObjectSchema)jsonSchemaElement;
            JsonObjectSchema.Builder builder = JsonObjectSchema.builder().description(jsonObjectSchema.description()).properties(InternalOpenAiHelper.toOpenAiProperties(jsonObjectSchema.properties(), strict)).additionalProperties(strict ? Boolean.FALSE : jsonObjectSchema.additionalProperties()).definitions(InternalOpenAiHelper.toOpenAiProperties(jsonObjectSchema.definitions(), strict));
            if (jsonObjectSchema.required() != null) {
                builder.required(jsonObjectSchema.required());
            }
            if (strict) {
                builder.required(new ArrayList(jsonObjectSchema.properties().keySet())).additionalProperties(Boolean.valueOf(false));
            }
            return builder.build();
        }
        if (jsonSchemaElement instanceof JsonArraySchema) {
            JsonArraySchema jsonArraySchema = (JsonArraySchema)jsonSchemaElement;
            return dev.ai4j.openai4j.chat.JsonArraySchema.builder().description(jsonArraySchema.description()).items(InternalOpenAiHelper.toOpenAiJsonSchemaElement(jsonArraySchema.items(), strict)).build();
        }
        if (jsonSchemaElement instanceof dev.langchain4j.model.chat.request.json.JsonEnumSchema) {
            dev.langchain4j.model.chat.request.json.JsonEnumSchema jsonEnumSchema = (dev.langchain4j.model.chat.request.json.JsonEnumSchema)jsonSchemaElement;
            return JsonEnumSchema.builder().description(jsonEnumSchema.description()).enumValues(jsonEnumSchema.enumValues()).build();
        }
        if (jsonSchemaElement instanceof dev.langchain4j.model.chat.request.json.JsonStringSchema) {
            dev.langchain4j.model.chat.request.json.JsonStringSchema jsonStringSchema = (dev.langchain4j.model.chat.request.json.JsonStringSchema)jsonSchemaElement;
            return JsonStringSchema.builder().description(jsonStringSchema.description()).build();
        }
        if (jsonSchemaElement instanceof JsonIntegerSchema) {
            JsonIntegerSchema jsonIntegerSchema = (JsonIntegerSchema)jsonSchemaElement;
            return dev.ai4j.openai4j.chat.JsonIntegerSchema.builder().description(jsonIntegerSchema.description()).build();
        }
        if (jsonSchemaElement instanceof JsonNumberSchema) {
            JsonNumberSchema jsonNumberSchema = (JsonNumberSchema)jsonSchemaElement;
            return dev.ai4j.openai4j.chat.JsonNumberSchema.builder().description(jsonNumberSchema.description()).build();
        }
        if (jsonSchemaElement instanceof dev.langchain4j.model.chat.request.json.JsonBooleanSchema) {
            dev.langchain4j.model.chat.request.json.JsonBooleanSchema jsonBooleanSchema = (dev.langchain4j.model.chat.request.json.JsonBooleanSchema)jsonSchemaElement;
            return JsonBooleanSchema.builder().description(jsonBooleanSchema.description()).build();
        }
        if (jsonSchemaElement instanceof JsonReferenceSchema) {
            JsonReferenceSchema jsonReferenceSchema = (JsonReferenceSchema)jsonSchemaElement;
            return dev.ai4j.openai4j.chat.JsonReferenceSchema.builder().reference("#/$defs/" + jsonReferenceSchema.reference()).build();
        }
        if (jsonSchemaElement instanceof JsonAnyOfSchema) {
            JsonAnyOfSchema jsonAnyOfSchema = (JsonAnyOfSchema)jsonSchemaElement;
            return dev.ai4j.openai4j.chat.JsonAnyOfSchema.builder().description(jsonAnyOfSchema.description()).anyOf(jsonAnyOfSchema.anyOf().stream().map(it -> InternalOpenAiHelper.toOpenAiJsonSchemaElement(it, strict)).collect(Collectors.toList())).build();
        }
        throw new IllegalArgumentException("Unknown type: " + String.valueOf(jsonSchemaElement.getClass()));
    }

    private static Map<String, dev.ai4j.openai4j.chat.JsonSchemaElement> toOpenAiPropertiesOld(Map<String, ?> properties, boolean strict) {
        LinkedHashMap<String, dev.ai4j.openai4j.chat.JsonSchemaElement> openAiProperties = new LinkedHashMap<String, dev.ai4j.openai4j.chat.JsonSchemaElement>();
        properties.forEach((key, value) -> openAiProperties.put((String)key, InternalOpenAiHelper.toOpenAiJsonSchemaElementOld((Map)value, strict)));
        return openAiProperties;
    }

    private static dev.ai4j.openai4j.chat.JsonSchemaElement toOpenAiJsonSchemaElementOld(Map<String, ?> properties, boolean strict) {
        Object type = properties.get("type");
        String description = (String)properties.get("description");
        if ("object".equals(type)) {
            List required = (List)properties.get("required");
            JsonObjectSchema.Builder builder = JsonObjectSchema.builder().description(description).properties(InternalOpenAiHelper.toOpenAiPropertiesOld((Map)properties.get("properties"), strict));
            if (required != null) {
                builder.required(required);
            }
            if (strict) {
                builder.required(new ArrayList(((Map)properties.get("properties")).keySet())).additionalProperties(Boolean.valueOf(false));
            }
            return builder.build();
        }
        if ("array".equals(type)) {
            return dev.ai4j.openai4j.chat.JsonArraySchema.builder().description(description).items(InternalOpenAiHelper.toOpenAiJsonSchemaElementOld((Map)properties.get("items"), strict)).build();
        }
        if (properties.get("enum") != null) {
            return JsonEnumSchema.builder().description(description).enumValues((List)properties.get("enum")).build();
        }
        if ("string".equals(type)) {
            return JsonStringSchema.builder().description(description).build();
        }
        if ("integer".equals(type)) {
            return dev.ai4j.openai4j.chat.JsonIntegerSchema.builder().description(description).build();
        }
        if ("number".equals(type)) {
            return dev.ai4j.openai4j.chat.JsonNumberSchema.builder().description(description).build();
        }
        if ("boolean".equals(type)) {
            return JsonBooleanSchema.builder().description(description).build();
        }
        throw new IllegalArgumentException("Unknown type " + String.valueOf(type));
    }

    public static AiMessage aiMessageFrom(ChatCompletionResponse response) {
        AssistantMessage assistantMessage = ((ChatCompletionChoice)response.choices().get(0)).message();
        String text = assistantMessage.content();
        List toolCalls = assistantMessage.toolCalls();
        if (!Utils.isNullOrEmpty((Collection)toolCalls)) {
            List toolExecutionRequests = toolCalls.stream().filter(toolCall -> toolCall.type() == ToolType.FUNCTION).map(InternalOpenAiHelper::toToolExecutionRequest).collect(Collectors.toList());
            return Utils.isNullOrBlank((String)text) ? AiMessage.from(toolExecutionRequests) : AiMessage.from((String)text, toolExecutionRequests);
        }
        FunctionCall functionCall = assistantMessage.functionCall();
        if (functionCall != null) {
            ToolExecutionRequest toolExecutionRequest = ToolExecutionRequest.builder().name(functionCall.name()).arguments(functionCall.arguments()).build();
            return Utils.isNullOrBlank((String)text) ? AiMessage.from((ToolExecutionRequest[])new ToolExecutionRequest[]{toolExecutionRequest}) : AiMessage.from((String)text, Collections.singletonList(toolExecutionRequest));
        }
        return AiMessage.from((String)text);
    }

    private static ToolExecutionRequest toToolExecutionRequest(ToolCall toolCall) {
        FunctionCall functionCall = toolCall.function();
        return ToolExecutionRequest.builder().id(toolCall.id()).name(functionCall.name()).arguments(functionCall.arguments()).build();
    }

    public static OpenAiTokenUsage tokenUsageFrom(Usage openAiUsage) {
        if (openAiUsage == null) {
            return null;
        }
        PromptTokensDetails promptTokensDetails = openAiUsage.promptTokensDetails();
        OpenAiTokenUsage.InputTokensDetails inputTokensDetails = null;
        if (promptTokensDetails != null) {
            inputTokensDetails = new OpenAiTokenUsage.InputTokensDetails(promptTokensDetails.cachedTokens());
        }
        CompletionTokensDetails completionTokensDetails = openAiUsage.completionTokensDetails();
        OpenAiTokenUsage.OutputTokensDetails outputTokensDetails = null;
        if (completionTokensDetails != null) {
            outputTokensDetails = new OpenAiTokenUsage.OutputTokensDetails(completionTokensDetails.reasoningTokens());
        }
        return OpenAiTokenUsage.builder().inputTokenCount(openAiUsage.promptTokens()).inputTokensDetails(inputTokensDetails).outputTokenCount(openAiUsage.completionTokens()).outputTokensDetails(outputTokensDetails).totalTokenCount(openAiUsage.totalTokens()).build();
    }

    public static FinishReason finishReasonFrom(String openAiFinishReason) {
        if (openAiFinishReason == null) {
            return null;
        }
        switch (openAiFinishReason) {
            case "stop": {
                return FinishReason.STOP;
            }
            case "length": {
                return FinishReason.LENGTH;
            }
            case "tool_calls": 
            case "function_call": {
                return FinishReason.TOOL_EXECUTION;
            }
            case "content_filter": {
                return FinishReason.CONTENT_FILTER;
            }
        }
        return null;
    }

    static ChatModelRequest createModelListenerRequest(ChatCompletionRequest request, List<ChatMessage> messages, List<ToolSpecification> toolSpecifications) {
        return ChatModelRequest.builder().model(request.model()).temperature(request.temperature()).topP(request.topP()).maxTokens((Integer)Utils.getOrDefault((Object)request.maxCompletionTokens(), (Object)request.maxTokens())).messages(messages).toolSpecifications(toolSpecifications).build();
    }

    static ChatModelResponse createModelListenerResponse(ChatResponse chatResponse) {
        if (chatResponse == null) {
            return null;
        }
        ChatResponseMetadata chatResponseMetadata = chatResponse.metadata();
        return ChatModelResponse.builder().id(chatResponseMetadata.id()).model(chatResponseMetadata.modelName()).tokenUsage(chatResponseMetadata.tokenUsage()).finishReason(chatResponseMetadata.finishReason()).aiMessage(chatResponse.aiMessage()).build();
    }

    static dev.ai4j.openai4j.chat.ResponseFormat toOpenAiResponseFormat(ResponseFormat responseFormat, Boolean strict) {
        if (responseFormat == null || responseFormat.type() == dev.langchain4j.model.chat.request.ResponseFormatType.TEXT) {
            return null;
        }
        JsonSchema jsonSchema = responseFormat.jsonSchema();
        if (jsonSchema == null) {
            return dev.ai4j.openai4j.chat.ResponseFormat.builder().type(ResponseFormatType.JSON_OBJECT).build();
        }
        if (!(jsonSchema.rootElement() instanceof dev.langchain4j.model.chat.request.json.JsonObjectSchema)) {
            throw new IllegalArgumentException("For OpenAI, the root element of the JSON Schema must be a JsonObjectSchema, but it was: " + String.valueOf(jsonSchema.rootElement().getClass()));
        }
        dev.ai4j.openai4j.chat.JsonSchema openAiJsonSchema = dev.ai4j.openai4j.chat.JsonSchema.builder().name(jsonSchema.name()).strict(strict).schema((JsonObjectSchema)InternalOpenAiHelper.toOpenAiJsonSchemaElement(jsonSchema.rootElement(), strict)).build();
        return dev.ai4j.openai4j.chat.ResponseFormat.builder().type(ResponseFormatType.JSON_SCHEMA).jsonSchema(openAiJsonSchema).build();
    }

    public static ToolChoiceMode toOpenAiToolChoice(ToolChoice toolChoice) {
        if (toolChoice == null) {
            return null;
        }
        return switch (toolChoice) {
            default -> throw new IncompatibleClassChangeError();
            case ToolChoice.AUTO -> ToolChoiceMode.AUTO;
            case ToolChoice.REQUIRED -> ToolChoiceMode.REQUIRED;
        };
    }

    public static Response<AiMessage> convertResponse(ChatResponse chatResponse) {
        return Response.from((Object)chatResponse.aiMessage(), (TokenUsage)chatResponse.metadata().tokenUsage(), (FinishReason)chatResponse.metadata().finishReason());
    }

    static StreamingChatResponseHandler convertHandler(final StreamingResponseHandler<AiMessage> handler) {
        return new StreamingChatResponseHandler(){

            public void onPartialResponse(String partialResponse) {
                handler.onNext(partialResponse);
            }

            public void onCompleteResponse(ChatResponse completeResponse) {
                handler.onComplete(InternalOpenAiHelper.convertResponse(completeResponse));
            }

            public void onError(Throwable error) {
                handler.onError(error);
            }
        };
    }

    static void validate(ChatRequestParameters parameters) {
        if (parameters.topK() != null) {
            throw new UnsupportedFeatureException("'topK' parameter is not supported by OpenAI");
        }
    }
}

