/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openai;

import dev.langchain4j.Experimental;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.model.chat.request.ChatRequestParameters;
import dev.langchain4j.model.chat.request.DefaultChatRequestParameters;
import dev.langchain4j.model.openai.OpenAiChatModelName;
import java.util.Map;
import java.util.Objects;

@Experimental
public class OpenAiChatRequestParameters
extends DefaultChatRequestParameters {
    private final Map<String, Integer> logitBias;
    private final Boolean parallelToolCalls;
    private final Integer seed;
    private final String user;
    private final Boolean store;
    private final Map<String, String> metadata;
    private final String serviceTier;

    private OpenAiChatRequestParameters(Builder builder) {
        super((DefaultChatRequestParameters.Builder)builder);
        this.logitBias = Utils.copyIfNotNull(builder.logitBias);
        this.parallelToolCalls = builder.parallelToolCalls;
        this.seed = builder.seed;
        this.user = builder.user;
        this.store = builder.store;
        this.metadata = Utils.copyIfNotNull(builder.metadata);
        this.serviceTier = builder.serviceTier;
    }

    OpenAiChatRequestParameters(ChatRequestParameters parameters) {
        super(parameters);
        if (parameters instanceof OpenAiChatRequestParameters) {
            OpenAiChatRequestParameters openAiParameters = (OpenAiChatRequestParameters)parameters;
            this.logitBias = Utils.copyIfNotNull(openAiParameters.logitBias);
            this.parallelToolCalls = openAiParameters.parallelToolCalls;
            this.seed = openAiParameters.seed;
            this.user = openAiParameters.user;
            this.store = openAiParameters.store;
            this.metadata = Utils.copyIfNotNull(openAiParameters.metadata);
            this.serviceTier = openAiParameters.serviceTier;
        } else {
            this.logitBias = null;
            this.parallelToolCalls = null;
            this.seed = null;
            this.user = null;
            this.store = null;
            this.metadata = null;
            this.serviceTier = null;
        }
    }

    public Map<String, Integer> logitBias() {
        return this.logitBias;
    }

    public Boolean parallelToolCalls() {
        return this.parallelToolCalls;
    }

    public Integer seed() {
        return this.seed;
    }

    public String user() {
        return this.user;
    }

    public Boolean store() {
        return this.store;
    }

    public Map<String, String> metadata() {
        return this.metadata;
    }

    public String serviceTier() {
        return this.serviceTier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OpenAiChatRequestParameters that = (OpenAiChatRequestParameters)((Object)o);
        return Objects.equals(this.logitBias, that.logitBias) && Objects.equals(this.parallelToolCalls, that.parallelToolCalls) && Objects.equals(this.seed, that.seed) && Objects.equals(this.user, that.user) && Objects.equals(this.store, that.store) && Objects.equals(this.metadata, that.metadata) && Objects.equals(this.serviceTier, that.serviceTier);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.logitBias, this.parallelToolCalls, this.seed, this.user, this.store, this.metadata, this.serviceTier);
    }

    public String toString() {
        return "OpenAiChatRequestParameters{modelName='" + this.modelName() + "', temperature=" + this.temperature() + ", topP=" + this.topP() + ", topK=" + this.topK() + ", frequencyPenalty=" + this.frequencyPenalty() + ", presencePenalty=" + this.presencePenalty() + ", maxOutputTokens=" + this.maxOutputTokens() + ", stopSequences=" + String.valueOf(this.stopSequences()) + ", toolSpecifications=" + String.valueOf(this.toolSpecifications()) + ", toolChoice=" + String.valueOf(this.toolChoice()) + ", responseFormat=" + String.valueOf(this.responseFormat()) + ", logitBias=" + String.valueOf(this.logitBias) + ", parallelToolCalls=" + this.parallelToolCalls + ", seed=" + this.seed + ", user='" + this.user + "', store=" + this.store + ", metadata=" + String.valueOf(this.metadata) + ", serviceTier='" + this.serviceTier + "'}";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DefaultChatRequestParameters.Builder<Builder> {
        private Map<String, Integer> logitBias;
        private Boolean parallelToolCalls;
        private Integer seed;
        private String user;
        private Boolean store;
        private Map<String, String> metadata;
        private String serviceTier;

        public Builder modelName(OpenAiChatModelName modelName) {
            return (Builder)super.modelName(modelName.toString());
        }

        public Builder logitBias(Map<String, Integer> logitBias) {
            this.logitBias = logitBias;
            return this;
        }

        public Builder parallelToolCalls(Boolean parallelToolCalls) {
            this.parallelToolCalls = parallelToolCalls;
            return this;
        }

        public Builder seed(Integer seed) {
            this.seed = seed;
            return this;
        }

        public Builder user(String user) {
            this.user = user;
            return this;
        }

        public Builder store(Boolean store) {
            this.store = store;
            return this;
        }

        public Builder metadata(Map<String, String> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder serviceTier(String serviceTier) {
            this.serviceTier = serviceTier;
            return this;
        }

        public OpenAiChatRequestParameters build() {
            return new OpenAiChatRequestParameters(this);
        }
    }
}

