/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.openai.internal.chat;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import dev.langchain4j.model.openai.internal.chat.JsonSchemaElement;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class JsonObjectSchema
extends JsonSchemaElement {
    @JsonProperty
    private final String description;
    @JsonProperty
    private final Map<String, JsonSchemaElement> properties;
    @JsonProperty
    private final List<String> required;
    @JsonProperty(value="additionalProperties")
    private final Boolean additionalProperties;
    @JsonProperty(value="$defs")
    private final Map<String, JsonSchemaElement> definitions;

    public JsonObjectSchema(Builder builder) {
        super("object");
        this.description = builder.description;
        this.properties = new LinkedHashMap<String, JsonSchemaElement>(builder.properties);
        this.required = new ArrayList<String>(builder.required);
        this.additionalProperties = builder.additionalProperties;
        this.definitions = builder.definitions == null ? null : new LinkedHashMap<String, JsonSchemaElement>(builder.definitions);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof JsonObjectSchema && this.equalTo((JsonObjectSchema)another);
    }

    private boolean equalTo(JsonObjectSchema another) {
        return Objects.equals(this.description, another.description) && Objects.equals(this.properties, another.properties) && Objects.equals(this.required, another.required) && Objects.equals(this.additionalProperties, another.additionalProperties) && Objects.equals(this.definitions, another.definitions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.properties);
        h += (h << 5) + Objects.hashCode(this.required);
        h += (h << 5) + Objects.hashCode(this.additionalProperties);
        h += (h << 5) + Objects.hashCode(this.definitions);
        return h;
    }

    public String toString() {
        return "JsonObjectSchema{description=" + this.description + ", properties=" + String.valueOf(this.properties) + ", required=" + String.valueOf(this.required) + ", additionalProperties=" + this.additionalProperties + ", definitions=" + String.valueOf(this.definitions) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class Builder {
        private String description;
        private Map<String, JsonSchemaElement> properties = new LinkedHashMap<String, JsonSchemaElement>();
        private List<String> required = new ArrayList<String>();
        private Boolean additionalProperties;
        private Map<String, JsonSchemaElement> definitions;

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder properties(Map<String, JsonSchemaElement> properties) {
            this.properties = properties;
            return this;
        }

        public Builder required(List<String> required) {
            this.required = required;
            return this;
        }

        public Builder additionalProperties(Boolean additionalProperties) {
            this.additionalProperties = additionalProperties;
            return this;
        }

        public Builder definitions(Map<String, JsonSchemaElement> definitions) {
            this.definitions = definitions;
            return this;
        }

        public JsonObjectSchema build() {
            return new JsonObjectSchema(this);
        }
    }
}

