/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.ui.passwordcallback.gui;

import es.gob.jmulticard.ui.passwordcallback.Messages;
import es.gob.jmulticard.ui.passwordcallback.gui.AccesibilityUtils;
import es.gob.jmulticard.ui.passwordcallback.gui.GeneralConfig;
import es.gob.jmulticard.ui.passwordcallback.gui.InputPasswordSmartcardDialog;
import es.gob.jmulticard.ui.passwordcallback.gui.ResizingAdaptor;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;

abstract class AbstractJAccessibilityCustomDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static int actualPositionX = -1;
    private static int actualPositionY = -1;
    private static int actualWidth = -1;
    private static int actualHeight = -1;
    private boolean bigSizeDefault = false;
    private final transient boolean isInputDialog;

    AbstractJAccessibilityCustomDialog(JDialog dialog, boolean modal, boolean isInputDlg) {
        super((Dialog)dialog, modal);
        this.isInputDialog = isInputDlg;
        ResizingAdaptor adaptador = new ResizingAdaptor(this);
        this.addComponentListener(adaptador);
        this.setResizable(false);
    }

    AbstractJAccessibilityCustomDialog(JFrame frame, boolean modal, boolean isInputDlg) {
        super((Frame)frame, modal);
        this.isInputDialog = isInputDlg;
        ResizingAdaptor adaptador = new ResizingAdaptor(this);
        this.addComponentListener(adaptador);
        this.setResizable(false);
    }

    AbstractJAccessibilityCustomDialog(boolean isInputDlg) {
        this.isInputDialog = isInputDlg;
        ResizingAdaptor adaptador = new ResizingAdaptor(this);
        this.addComponentListener(adaptador);
        this.setResizable(false);
    }

    abstract int getMinimumRelation();

    static int getActualPositionX() {
        return actualPositionX;
    }

    static void setActualPositionX(int positionX) {
        actualPositionX = positionX;
    }

    static int getActualPositionY() {
        return actualPositionY;
    }

    static void setActualPositionY(int positionY) {
        actualPositionY = positionY;
    }

    static int getActualWidth() {
        return actualWidth;
    }

    static void setActualWidth(int width) {
        actualWidth = width;
    }

    static int getActualHeight() {
        return actualHeight;
    }

    static void setActualHeight(int height) {
        actualHeight = height;
    }

    boolean isBigSizeDefault() {
        return this.bigSizeDefault;
    }

    void setBigSizeDefault(boolean bigSizeByDefault) {
        this.bigSizeDefault = bigSizeByDefault;
    }

    int getInitialWidth() {
        if (this.isInputDialog) {
            return 530;
        }
        return 460;
    }

    int getInitialHeight() {
        if (this.isInputDialog) {
            return 210;
        }
        return 190;
    }

    int getMaxWidth() {
        if (this.isInputDialog) {
            return 770;
        }
        return 700;
    }

    int getMaxHeight() {
        if (this.isInputDialog) {
            return 299;
        }
        return 305;
    }

    protected JPanel createAccessibilityButtonsPanel() {
        JPanel accessibilityButtonsPanel = new JPanel(new GridBagLayout());
        final JWindow tip = new JWindow();
        final JLabel tipText = new JLabel();
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints consButtons = new GridBagConstraints();
        consButtons.fill = 1;
        consButtons.gridx = 0;
        consButtons.gridy = 0;
        consButtons.weightx = 1.0;
        consButtons.weighty = 1.0;
        consButtons.insets = new Insets(0, 0, 0, 0);
        JPanel restorePanel = new JPanel();
        ImageIcon imageIconRestore = new ImageIcon(InputPasswordSmartcardDialog.class.getResource("/images/restore.png"));
        final JButton restoreButton = new JButton(imageIconRestore);
        restoreButton.setMnemonic(82);
        restoreButton.setToolTipText(Messages.getString("Wizard.restaurar.description"));
        restoreButton.getAccessibleContext().setAccessibleName(restoreButton.getToolTipText());
        restoreButton.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                AccesibilityUtils.showToolTip(false, tip, restoreButton, tipText);
            }

            @Override
            public void focusGained(FocusEvent e) {
                AccesibilityUtils.showToolTip(true, tip, restoreButton, tipText);
            }
        });
        Dimension dimension = new Dimension(20, 20);
        restoreButton.setPreferredSize(dimension);
        restoreButton.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyPressed(KeyEvent ke) {
                if (10 == ke.getKeyCode()) {
                    restoreButton.doClick();
                }
            }
        });
        restoreButton.setName("restaurar");
        restorePanel.add(restoreButton);
        AccesibilityUtils.remarcar(restoreButton);
        panel.add((Component)restorePanel, consButtons);
        consButtons.gridx = 1;
        consButtons.insets = new Insets(0, 0, 0, 0);
        JPanel maximizePanel = new JPanel();
        ImageIcon imageIconMaximize = new ImageIcon(InputPasswordSmartcardDialog.class.getResource("/images/maximize.png"));
        final JButton maximizeButton = new JButton(imageIconMaximize);
        maximizeButton.setMnemonic(77);
        maximizeButton.setToolTipText(Messages.getString("Wizard.maximizar.description"));
        maximizeButton.getAccessibleContext().setAccessibleName(maximizeButton.getToolTipText());
        maximizeButton.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyPressed(KeyEvent ke) {
                if (10 == ke.getKeyCode()) {
                    maximizeButton.doClick();
                }
            }
        });
        maximizeButton.setName("maximizar");
        maximizeButton.setPreferredSize(dimension);
        AccesibilityUtils.remarcar(maximizeButton);
        maximizePanel.add(maximizeButton);
        maximizeButton.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                AccesibilityUtils.showToolTip(false, tip, maximizeButton, tipText);
            }

            @Override
            public void focusGained(FocusEvent e) {
                AccesibilityUtils.showToolTip(true, tip, maximizeButton, tipText);
            }
        });
        panel.add((Component)maximizePanel, consButtons);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = new Insets(0, 0, 0, 0);
        c.anchor = 15;
        accessibilityButtonsPanel.add((Component)panel, c);
        restoreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractJAccessibilityCustomDialog.this.restaurarActionPerformed(restoreButton, maximizeButton);
            }
        });
        maximizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractJAccessibilityCustomDialog.this.maximizarActionPerformed(restoreButton, maximizeButton);
            }
        });
        if (GeneralConfig.isMaximized()) {
            maximizeButton.setEnabled(false);
            restoreButton.setEnabled(true);
        } else {
            maximizeButton.setEnabled(true);
            restoreButton.setEnabled(false);
        }
        return accessibilityButtonsPanel;
    }

    void maximizarActionPerformed(JButton restoreButton, JButton maximizeButton) {
        AbstractJAccessibilityCustomDialog.setActualPositionX(this.getX());
        AbstractJAccessibilityCustomDialog.setActualPositionY(this.getY());
        AbstractJAccessibilityCustomDialog.setActualWidth(this.getWidth());
        AbstractJAccessibilityCustomDialog.setActualHeight(this.getHeight());
        int maxWidth = this.getMaxWidth();
        int maxHeight = this.getMaxHeight();
        this.setBounds(AbstractJAccessibilityCustomDialog.getInitialX(maxWidth), AbstractJAccessibilityCustomDialog.getInitialY(maxHeight), maxWidth, maxHeight);
        maximizeButton.setEnabled(false);
        restoreButton.setEnabled(true);
    }

    void restaurarActionPerformed(JButton restoreButton, JButton maximizeButton) {
        int minWidth = this.getInitialWidth();
        int minHeight = this.getInitialHeight();
        if (GeneralConfig.isBigFontSize() || GeneralConfig.isFontBold() || this.isBigSizeDefault()) {
            minWidth = 555;
            minHeight = 250;
        }
        this.setMinimumSize(new Dimension(minWidth, minHeight));
        if (AbstractJAccessibilityCustomDialog.getActualPositionX() != -1 && AbstractJAccessibilityCustomDialog.getActualPositionY() != -1 && AbstractJAccessibilityCustomDialog.getActualWidth() != -1 && AbstractJAccessibilityCustomDialog.getActualHeight() != -1) {
            this.setBounds(AbstractJAccessibilityCustomDialog.getActualPositionX(), AbstractJAccessibilityCustomDialog.getActualPositionY(), AbstractJAccessibilityCustomDialog.getActualWidth(), AbstractJAccessibilityCustomDialog.getActualHeight());
        } else {
            this.setBounds(AbstractJAccessibilityCustomDialog.getInitialX(minWidth), AbstractJAccessibilityCustomDialog.getInitialY(minHeight), minWidth, minHeight);
        }
        maximizeButton.setEnabled(true);
        restoreButton.setEnabled(false);
    }

    private static int getInitialX(int width) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        return screenSize.width / 2 - width / 2;
    }

    private static int getInitialY(int height) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        return screenSize.height / 2 - height / 2;
    }

    protected static final class ButtonAbstractAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private final transient JButton button;

        ButtonAbstractAction(JButton actionButton) {
            this.button = actionButton;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (this.button != null) {
                this.button.doClick();
            }
        }
    }
}

