/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.ui.passwordcallback.gui;

import es.gob.jmulticard.ui.passwordcallback.gui.GeneralConfig;
import java.awt.Color;
import java.awt.Font;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;

final class AccesibilityUtils {
    private static final boolean HIGH_CONTRAST;

    static boolean isHighContrast() {
        return HIGH_CONTRAST;
    }

    private AccesibilityUtils() {
    }

    static void remarcar(JComponent component) {
        if (GeneralConfig.isRemarked()) {
            if (component instanceof JButton) {
                final JButton button = (JButton)component;
                button.addFocusListener(new FocusListener(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        if (button.getParent() instanceof JPanel) {
                            ((JPanel)button.getParent()).setBorder(BorderFactory.createEmptyBorder());
                        }
                    }

                    @Override
                    public void focusGained(FocusEvent e) {
                        if (GeneralConfig.isHighContrast() || AccesibilityUtils.isHighContrast()) {
                            if (button.getParent() instanceof JPanel) {
                                ((JPanel)button.getParent()).setBorder(BorderFactory.createLineBorder(Color.WHITE, 2));
                            }
                        } else if (button.getParent() instanceof JPanel) {
                            ((JPanel)button.getParent()).setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
                        }
                    }
                });
            }
            if (component instanceof JTextField) {
                final JTextField textField = (JTextField)component;
                textField.addFocusListener(new FocusListener(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        textField.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1));
                    }

                    @Override
                    public void focusGained(FocusEvent e) {
                        if (GeneralConfig.isHighContrast() || AccesibilityUtils.isHighContrast()) {
                            textField.setBorder(BorderFactory.createLineBorder(Color.WHITE, 2));
                        } else {
                            textField.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
                        }
                    }
                });
            }
            if (component instanceof JComboBox) {
                final JComboBox comboBox = (JComboBox)component;
                comboBox.addFocusListener(new FocusListener(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        comboBox.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1));
                    }

                    @Override
                    public void focusGained(FocusEvent e) {
                        if (GeneralConfig.isHighContrast() || AccesibilityUtils.isHighContrast()) {
                            comboBox.setBorder(BorderFactory.createLineBorder(Color.WHITE, 2));
                        } else {
                            comboBox.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
                        }
                    }
                });
            }
            if (component instanceof JLabel) {
                final JLabel label = (JLabel)component;
                label.addFocusListener(new FocusListener(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        label.setBorder(BorderFactory.createEmptyBorder());
                    }

                    @Override
                    public void focusGained(FocusEvent e) {
                        if (GeneralConfig.isHighContrast() || AccesibilityUtils.isHighContrast()) {
                            label.setBorder(BorderFactory.createLineBorder(Color.WHITE, 2));
                        } else {
                            label.setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
                        }
                    }
                });
            }
            if (component instanceof JCheckBox) {
                final JCheckBox checkBox = (JCheckBox)component;
                checkBox.addFocusListener(new FocusListener(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        ((JPanel)checkBox.getParent()).setBorder(BorderFactory.createEmptyBorder());
                    }

                    @Override
                    public void focusGained(FocusEvent e) {
                        if (GeneralConfig.isHighContrast() || AccesibilityUtils.isHighContrast()) {
                            ((JPanel)checkBox.getParent()).setBorder(BorderFactory.createLineBorder(Color.WHITE, 2));
                        } else {
                            ((JPanel)checkBox.getParent()).setBorder(BorderFactory.createLineBorder(Color.BLACK, 2));
                        }
                    }
                });
            }
        }
    }

    static void setContrastColor(JComponent component) {
        if (GeneralConfig.isHighContrast()) {
            if (component instanceof JComboBox || component instanceof JPasswordField || component instanceof JTextField) {
                component.setBackground(Color.WHITE);
            } else if (component instanceof JCheckBox) {
                component.setForeground(Color.WHITE);
            } else {
                if (component instanceof JPanel && component.getBorder() instanceof TitledBorder) {
                    ((TitledBorder)component.getBorder()).setTitleColor(Color.WHITE);
                }
                component.setForeground(Color.WHITE);
                component.setBackground(Color.BLACK);
            }
        }
    }

    static void setFontBold(JComponent component) {
        if (component instanceof JPanel) {
            TitledBorder titledBorder;
            if (component.getBorder() instanceof TitledBorder && (titledBorder = (TitledBorder)component.getBorder()) != null) {
                if (GeneralConfig.isFontBold()) {
                    titledBorder.setTitleFont(new Font(component.getFont().getName(), 1, component.getFont().getSize()));
                } else {
                    titledBorder.setTitleFont(new Font(component.getFont().getName(), 0, component.getFont().getSize()));
                }
            }
        } else if (GeneralConfig.isFontBold()) {
            component.setFont(new Font(component.getFont().getName(), 1, component.getFont().getSize()));
        } else {
            component.setFont(new Font(component.getFont().getName(), 0, component.getFont().getSize()));
        }
    }

    static String remarkMnemonic(String text, int key) {
        String newText = text;
        int pos = text.indexOf(key);
        if (pos == -1) {
            char keyChar = (char)key;
            pos = text.indexOf(String.valueOf(keyChar).toLowerCase(Locale.getDefault()));
        }
        if (pos != -1) {
            newText = text.substring(0, pos) + "<u>" + text.charAt(pos) + "</u>" + text.substring(pos + 1);
        }
        return newText;
    }

    static void remarkMnemonic(AbstractButton button, int key) {
        String text = button.getText();
        int pos = text.toLowerCase(Locale.getDefault()).indexOf(key);
        if (pos != -1) {
            button.setDisplayedMnemonicIndex(pos);
        }
    }

    static void showToolTip(boolean show, JWindow tip, JButton boton, JLabel tipText) {
        tipText.setText(boton.getToolTipText());
        tip.setBackground((Color)UIManager.get("ToolTip.background"));
        tipText.setBackground((Color)UIManager.get("ToolTip.background"));
        tipText.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.BLACK), BorderFactory.createEmptyBorder(0, 3, 0, 3)));
        tipText.setFont((Font)UIManager.get("ToolTip.font"));
        tipText.setOpaque(true);
        tip.add(tipText);
        Point point = new Point();
        try {
            point = boton.getLocationOnScreen();
        }
        catch (IllegalComponentStateException e) {
            Logger.getLogger("es.gob.jmulticard").warning("Error mostrando el tooltip: " + e);
        }
        int factor = 0;
        if (boton.getSize().getHeight() > 34.0) {
            factor = (int)(boton.getSize().getHeight() * 0.5);
        }
        tip.setLocation((int)point.getX(), (int)point.getY() + 30 + factor);
        tip.pack();
        tip.setVisible(show);
    }

    static {
        Object highContrast = Toolkit.getDefaultToolkit().getDesktopProperty("win.highContrast.on");
        HIGH_CONTRAST = highContrast instanceof Boolean ? (Boolean)highContrast : System.getProperty("os.name") != null && System.getProperty("os.name").contains("inux");
    }
}

