/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.ui.passwordcallback.gui;

import es.gob.jmulticard.ui.passwordcallback.PasswordCallbackManager;
import es.gob.jmulticard.ui.passwordcallback.gui.ConsolePasswordCallback;
import es.gob.jmulticard.ui.passwordcallback.gui.UIPasswordCallbackAccessibility;
import java.awt.HeadlessException;
import java.security.KeyStore;
import java.util.logging.Logger;
import javax.security.auth.callback.PasswordCallback;

public final class CommonPasswordCallback
extends PasswordCallback {
    private static final long serialVersionUID = 5514503307266079255L;
    private static boolean headless = false;
    private final transient String title;
    private final transient boolean isDnie;
    private final transient boolean allowUseCache;
    private final transient boolean defaultUseCacheValue;
    private transient boolean useCacheChecked;

    static void setHeadLess(boolean hl) {
        headless = hl;
    }

    public CommonPasswordCallback(String prompt, String dialogTitle, boolean isDni) {
        this(prompt, dialogTitle, isDni, false, false);
    }

    public CommonPasswordCallback(String prompt, String dialogTitle, boolean isDni, boolean allowPinCache, boolean defaultPinCacheValue) {
        super(prompt, true);
        if (prompt == null) {
            throw new IllegalArgumentException("El texto de solicitud no puede ser nulo");
        }
        this.title = dialogTitle == null ? prompt : dialogTitle;
        this.isDnie = isDni;
        this.allowUseCache = allowPinCache;
        this.useCacheChecked = this.defaultUseCacheValue = defaultPinCacheValue;
    }

    public CommonPasswordCallback(KeyStore.PasswordProtection pp) {
        super("Por favor, introduzca el PIN de su tarjeta", false);
        if (pp == null) {
            throw new IllegalArgumentException("El PasswordProtection no puede ser nulo");
        }
        this.title = this.getPrompt();
        this.isDnie = false;
        this.allowUseCache = false;
        this.useCacheChecked = this.defaultUseCacheValue = false;
    }

    @Override
    public char[] getPassword() {
        if (!headless) {
            try {
                UIPasswordCallbackAccessibility psc = this.isDnie ? new UIPasswordCallbackAccessibility(this.getPrompt(), PasswordCallbackManager.getDialogOwner(), this.getPrompt(), 80, this.title, "/images/dnie.png", this.allowUseCache, this.defaultUseCacheValue) : new UIPasswordCallbackAccessibility(this.getPrompt(), PasswordCallbackManager.getDialogOwner(), this.getPrompt(), 80, this.title, "/images/chipcard.png", this.allowUseCache, this.defaultUseCacheValue);
                char[] pss = psc.getPassword();
                this.useCacheChecked = psc.isUseCacheChecked();
                psc.clearPassword();
                psc = null;
                return pss;
            }
            catch (HeadlessException e) {
                Logger.getLogger("es.gob.jmulticard").info("No hay entorno grafico, se revierte a consola: " + e);
            }
        }
        ConsolePasswordCallback cpc = new ConsolePasswordCallback(this.getPrompt());
        char[] pss = cpc.getPassword();
        cpc.clearPassword();
        cpc = null;
        return pss;
    }

    public boolean isUseCacheChecked() {
        return this.useCacheChecked;
    }

    static {
        CommonPasswordCallback.setHeadLess(Boolean.getBoolean("java.awt.headless"));
    }
}

