/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.ui.passwordcallback.gui;

import es.gob.jmulticard.ui.passwordcallback.Messages;
import es.gob.jmulticard.ui.passwordcallback.gui.AbstractJAccessibilityCustomDialog;
import es.gob.jmulticard.ui.passwordcallback.gui.AccesibilityUtils;
import es.gob.jmulticard.ui.passwordcallback.gui.GeneralConfig;
import es.gob.jmulticard.ui.passwordcallback.gui.IconLabel;
import es.gob.jmulticard.ui.passwordcallback.gui.InfoLabel;
import es.gob.jmulticard.ui.passwordcallback.gui.RequestFocusListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public final class ConfirmSmartcardDialog
extends AbstractJAccessibilityCustomDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private transient InfoLabel infoLabel = null;
    private transient JPanel buttonsPanel = null;
    private final transient IconLabel iconLabel = new IconLabel();
    private static JButton okButton = null;
    private transient JButton noButton = null;
    private static JButton cancelButton = null;
    private transient int answer;
    private static String cancellText = Messages.getString("PrincipalGUI.cancelar");

    static JButton getOkButton() {
        return okButton;
    }

    JButton getNoButton() {
        return this.noButton;
    }

    static JButton getCancelButton() {
        return cancelButton;
    }

    protected ConfirmSmartcardDialog(JDialog componentParent, boolean modal, String message, String title, String iconPath) {
        super(componentParent, modal, false);
        this.initComponents(message, title, iconPath);
        this.setLocationRelativeTo(componentParent);
        this.pack();
    }

    protected ConfirmSmartcardDialog(Component componentParent, boolean modal, String message, String title, String iconPath) {
        super(false);
        this.setModal(modal);
        this.initComponents(message, title, iconPath);
        this.setLocationRelativeTo(componentParent);
        this.pack();
    }

    private ConfirmSmartcardDialog(JFrame componentParent, boolean modal, String message, String title, String iconPath) {
        super(componentParent, modal, false);
        this.initComponents(message, title, iconPath);
        this.setLocationRelativeTo(componentParent);
        this.pack();
    }

    protected void initComponents(String message, String title, String iconPath) {
        int maxWidth = this.getMaxWidth();
        int maxHeight = this.getMaxHeight();
        this.setMinimumSize(new Dimension(this.getInitialWidth(), this.getInitialHeight()));
        this.setPreferredSize(new Dimension(this.getInitialWidth(), this.getInitialHeight()));
        this.setMaximumSize(new Dimension(maxWidth, maxHeight));
        if (GeneralConfig.isMaximized()) {
            this.setBounds(0, 0, maxWidth, maxHeight);
        } else if (GeneralConfig.isBigFontSize() || GeneralConfig.isFontBold()) {
            this.setMinimumSize(new Dimension(555, 250));
        }
        this.setTitle(title);
        this.setDefaultCloseOperation(2);
        this.answer = 1;
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        JPanel mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(5, 10, 0, 10);
        this.setIconLabel(iconPath);
        JPanel iconPanel = new JPanel(new GridBagLayout());
        GridBagConstraints consIconPanel = new GridBagConstraints();
        consIconPanel.fill = 1;
        iconPanel.add((Component)this.iconLabel, consIconPanel);
        c.insets = new Insets(10, 5, 0, 10);
        ++c.gridx;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.infoLabel = new InfoLabel(message, false);
        this.infoLabel.setHorizontalAlignment(0);
        this.infoLabel.addAncestorListener(new RequestFocusListener());
        this.infoLabel.setVerticalAlignment(0);
        mainPanel.add((Component)this.infoLabel, c);
        this.createMainButtonsPanel();
        JPanel accessibilityButtonsPanel = this.createAccessibilityButtonsPanel();
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 1;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.gridwidth = 2;
        cons.gridheight = 1;
        cons.weighty = 0.0;
        cons.weightx = 0.1;
        container.add((Component)accessibilityButtonsPanel, cons);
        cons.gridx = 2;
        cons.gridy = 0;
        cons.gridwidth = 6;
        cons.gridheight = 3;
        cons.weighty = 0.65;
        cons.weightx = 0.9;
        container.add((Component)mainPanel, cons);
        cons.gridx = 0;
        cons.gridy = 1;
        cons.gridwidth = 2;
        cons.gridheight = 3;
        cons.weighty = 0.9;
        cons.weightx = 0.0;
        container.add((Component)iconPanel, cons);
        cons.gridx = 2;
        cons.gridy = 3;
        cons.gridwidth = 6;
        cons.gridheight = 1;
        cons.weighty = 0.35;
        cons.weightx = 0.0;
        container.add((Component)this.buttonsPanel, cons);
        this.pack();
    }

    protected void setIconLabel(String iconPath) {
        if (iconPath != null) {
            ImageIcon icon = new ImageIcon(ConfirmSmartcardDialog.class.getResource(iconPath));
            Dimension dimensionInicial = new Dimension(100, (int)(100.0f / (float)icon.getIconWidth() * (float)icon.getIconHeight()));
            this.iconLabel.setOriginalIcon(icon);
            this.iconLabel.setOriginalDimension(dimensionInicial);
            icon = new ImageIcon(icon.getImage().getScaledInstance(dimensionInicial.width, dimensionInicial.height, 4));
            this.iconLabel.setIcon(icon);
        }
    }

    void createMainButtonsPanel() {
        this.buttonsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints consButtons = new GridBagConstraints();
        consButtons.fill = 0;
        consButtons.gridx = 0;
        consButtons.gridy = 0;
        consButtons.insets = new Insets(0, 10, 0, 10);
        consButtons.anchor = 10;
        JPanel okPanel = new JPanel();
        okButton = this.getButton(Messages.getString("PrincipalGUI.aceptar"), 65);
        okButton.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    ConfirmSmartcardDialog.getOkButton().doClick();
                }
            }
        });
        okPanel.add(okButton);
        this.buttonsPanel.add((Component)okPanel, consButtons);
        okButton.addActionListener(this);
    }

    public static int showConfirmDialog(Component componentParent, boolean modal, String message, String title, int typeOption, String iconPath) {
        final ConfirmSmartcardDialog customDialog = ConfirmSmartcardDialog.getInstanceCustomDialog(componentParent, modal, message, title, iconPath);
        okButton.setEnabled(true);
        customDialog.getRootPane().setDefaultButton(null);
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 2;
        cons.gridy = 0;
        cons.insets = new Insets(0, 0, 0, 10);
        if (typeOption != 0) {
            throw new UnsupportedOperationException("Solo se soportan dialogos de tipo Si/No");
        }
        okButton.setText(Messages.getString("CustomDialog.confirmDialog.yes"));
        okButton.setMnemonic(83);
        customDialog.noButton = customDialog.getButton(Messages.getString("CustomDialog.confirmDialog.no"), 78);
        customDialog.noButton.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    customDialog.getNoButton().doClick();
                }
            }
        });
        JPanel noPanel = new JPanel();
        noPanel.add(customDialog.noButton);
        customDialog.buttonsPanel.add((Component)noPanel, cons);
        customDialog.noButton.addActionListener(customDialog);
        customDialog.infoLabel.setHorizontalAlignment(0);
        customDialog.pack();
        customDialog.setSize(customDialog.getInitialWidth() + 1, customDialog.getInitialHeight() + 1);
        customDialog.setVisible(true);
        return customDialog.getAnswer();
    }

    private JButton getButton(String text, int mnemonic) {
        JButton button = new JButton(text);
        button.setMnemonic(mnemonic);
        AccesibilityUtils.remarcar(button);
        AccesibilityUtils.setContrastColor(button);
        AccesibilityUtils.setFontBold(button);
        if (text.equalsIgnoreCase(cancellText)) {
            String cancelKey = "cancel";
            this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
            this.getRootPane().getActionMap().put("cancel", new AbstractJAccessibilityCustomDialog.ButtonAbstractAction(ConfirmSmartcardDialog.getCancelButton()));
        }
        return button;
    }

    @Override
    public int getMinimumRelation() {
        return 7;
    }

    private int getAnswer() {
        return this.answer;
    }

    static ConfirmSmartcardDialog getInstanceCustomDialog(Component componentParent, boolean modal, String message, String title, String iconPath) {
        ConfirmSmartcardDialog customDialog = componentParent instanceof JDialog ? new ConfirmSmartcardDialog((JDialog)componentParent, modal, message, title, iconPath) : (componentParent instanceof JFrame ? new ConfirmSmartcardDialog((JFrame)componentParent, modal, message, title, iconPath) : new ConfirmSmartcardDialog(componentParent, modal, message, title, iconPath));
        return customDialog;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.answer = e.getSource().equals(okButton) ? 0 : (e.getSource().equals(this.noButton) ? 1 : 2);
        this.setVisible(false);
    }
}

