/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.ui.passwordcallback.gui;

import es.gob.jmulticard.CancelledOperationException;
import es.gob.jmulticard.ui.passwordcallback.Messages;
import es.gob.jmulticard.ui.passwordcallback.NoConsoleException;
import java.io.Console;
import java.util.Arrays;
import javax.security.auth.callback.PasswordCallback;

final class ConsolePasswordCallback
extends PasswordCallback {
    private static final long serialVersionUID = -4044214967262414899L;
    private final transient String prompt;

    ConsolePasswordCallback(String p) {
        super(p, true);
        this.prompt = p;
    }

    private static String removeHTML(String input) {
        return input.replace("<br/>", "").replace("&nbsp;", "");
    }

    @Override
    public char[] getPassword() {
        Console console = System.console();
        if (console == null) {
            throw new NoConsoleException("No hay consola para solicitar el PIN");
        }
        char[] password = console.readPassword(ConsolePasswordCallback.removeHTML(this.prompt) + ":\n", new Object[0]);
        if (password == null) {
            throw new CancelledOperationException("Se ha cancelado la introduccion de PIN en consola");
        }
        if (password.length < 8 || password.length > 16) {
            console.printf(Messages.getString("ConsolePasswordCallback.1") + "\n", new Object[0]);
            Arrays.fill(password, '\u0000');
            return this.getPassword();
        }
        console.flush();
        console = null;
        return password;
    }
}

