/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.ui.passwordcallback.gui;

import es.gob.jmulticard.callback.CustomAuthorizeCallback;
import es.gob.jmulticard.card.dnie.CacheElement;
import es.gob.jmulticard.ui.passwordcallback.DialogBuilder;
import es.gob.jmulticard.ui.passwordcallback.Messages;
import es.gob.jmulticard.ui.passwordcallback.gui.CommonPasswordCallback;
import es.gob.jmulticard.ui.passwordcallback.gui.ResetCacheTimerTask;
import es.gob.jmulticard.ui.passwordcallback.gui.UIPasswordCallbackCan;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public final class DnieCacheCallbackHandler
implements CallbackHandler,
CacheElement {
    private static final Logger LOGGER = Logger.getLogger("es.gob.jmulticard");
    private static final long CACHE_TIMEOUT = 3600000L;
    private static final String PREFERENCE_KEY_USE_CACHE = "useCacheDni";
    private transient char[] cachedPassword = null;
    private transient boolean confirmed = false;
    private transient Timer timer = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        if (callbacks != null) {
            for (Callback cb : callbacks) {
                if (cb == null) continue;
                if ("es.gob.jmulticard.callback.CustomTextInputCallback".equals(cb.getClass().getName()) || "javax.security.auth.callback.TextInputCallback".equals(cb.getClass().getName())) {
                    try {
                        Method m = cb.getClass().getMethod("setText", String.class);
                        UIPasswordCallbackCan uip = new UIPasswordCallbackCan(Messages.getString("CanPasswordCallback.0"), null, Messages.getString("CanPasswordCallback.0"), Messages.getString("CanPasswordCallback.2"));
                        m.invoke((Object)cb, new String(uip.getPassword()));
                        continue;
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        throw new UnsupportedCallbackException(cb, "No se ha podido invocar al metodo 'setText' de la callback: " + e);
                    }
                }
                if (cb instanceof CustomAuthorizeCallback) {
                    if (!this.confirmed) {
                        DialogBuilder.showSignatureConfirmDialog((CustomAuthorizeCallback)cb);
                        this.confirmed = ((CustomAuthorizeCallback)cb).isAuthorized();
                    }
                    ((CustomAuthorizeCallback)cb).setAuthorized(this.confirmed);
                    continue;
                }
                if (cb instanceof PasswordCallback) {
                    Logger logger = LOGGER;
                    synchronized (logger) {
                        char[] pin;
                        if (this.cachedPassword == null) {
                            boolean useCacheDefaultValue = DnieCacheCallbackHandler.loadUseCachePreference();
                            CommonPasswordCallback uip = new CommonPasswordCallback(((PasswordCallback)cb).getPrompt(), Messages.getString("CommonPasswordCallback.1"), true, true, useCacheDefaultValue);
                            pin = uip.getPassword();
                            boolean newUseCacheDefaultValue = uip.isUseCacheChecked();
                            if (newUseCacheDefaultValue) {
                                LOGGER.info("Guardamos en cache la contrasena de la tarjeta");
                                this.cachedPassword = pin;
                            }
                            if (useCacheDefaultValue != newUseCacheDefaultValue) {
                                DnieCacheCallbackHandler.setUseCachePreference(newUseCacheDefaultValue);
                            }
                        } else {
                            pin = this.cachedPassword;
                        }
                        ((PasswordCallback)cb).setPassword(pin);
                    }
                    if (this.timer != null) continue;
                    this.timer = new Timer();
                    this.timer.schedule((TimerTask)new ResetCacheTimerTask(this), 3600000L);
                    continue;
                }
                throw new UnsupportedCallbackException(cb);
            }
        } else {
            LOGGER.warning("Se ha recibido un array de Callbacks nulo");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        LOGGER.info("Eliminamos de cache la contrasena de la tarjeta");
        Logger logger = LOGGER;
        synchronized (logger) {
            this.cachedPassword = null;
            this.confirmed = false;
        }
        if (this.timer != null) {
            this.timer.cancel();
            this.timer.purge();
            this.timer = null;
        }
    }

    private static boolean loadUseCachePreference() {
        try {
            return Preferences.userNodeForPackage(DnieCacheCallbackHandler.class).getBoolean(PREFERENCE_KEY_USE_CACHE, false);
        }
        catch (Exception e) {
            LOGGER.warning("No se puede acceder a la configuracion del cacheo del PIN de la tarjeta: " + e);
            return false;
        }
    }

    private static void setUseCachePreference(boolean useCache) {
        try {
            Preferences.userNodeForPackage(DnieCacheCallbackHandler.class).putBoolean(PREFERENCE_KEY_USE_CACHE, useCache);
        }
        catch (Exception e) {
            LOGGER.warning("No se pudo guardar la configuracion del cacheo del PIN de la tarjeta: " + e);
        }
    }
}

