/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.ui.passwordcallback.gui;

import es.gob.jmulticard.CancelledOperationException;
import es.gob.jmulticard.ui.passwordcallback.Messages;
import es.gob.jmulticard.ui.passwordcallback.gui.AbstractJAccessibilityCustomDialog;
import es.gob.jmulticard.ui.passwordcallback.gui.AccesibilityUtils;
import es.gob.jmulticard.ui.passwordcallback.gui.GeneralConfig;
import es.gob.jmulticard.ui.passwordcallback.gui.IconLabel;
import es.gob.jmulticard.ui.passwordcallback.gui.InfoLabel;
import es.gob.jmulticard.ui.passwordcallback.gui.JSecurePasswordLabel;
import es.gob.jmulticard.ui.passwordcallback.gui.PasswordResult;
import es.gob.jmulticard.ui.passwordcallback.gui.RequestFocusListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public final class InputPasswordSmartcardDialog
extends AbstractJAccessibilityCustomDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final int PIN_MIN_LENGTH = 4;
    private static final int PIN_MAX_LENGTH = 16;
    private static JButton okButton = null;
    private static JButton cancelButton = null;
    private static String cancellText = Messages.getString("PrincipalGUI.cancelar");
    private transient InfoLabel infoLabel = null;
    private transient JPanel buttonsPanel = null;
    private transient JPanel mainPanel = null;
    private transient JSecurePasswordLabel component = null;
    private transient JCheckBox useCacheCheckBox = null;
    private final transient IconLabel iconLabel = new IconLabel();
    private transient int answer;

    static JButton getOkButton() {
        return okButton;
    }

    static JButton getCancelButton() {
        return cancelButton;
    }

    private InputPasswordSmartcardDialog(JDialog componentParent, boolean modal, String message, String title, String iconPath, boolean allowUseCache, boolean defaultUseCache) {
        super(componentParent, modal, true);
        this.initComponents(message, title, iconPath, allowUseCache, defaultUseCache);
        this.setLocationRelativeTo(componentParent);
        this.pack();
    }

    private InputPasswordSmartcardDialog(Component componentParent, boolean modal, String message, String title, String iconPath, boolean allowUseCache, boolean defaultUseCache) {
        super(true);
        this.setModal(modal);
        this.initComponents(message, title, iconPath, allowUseCache, defaultUseCache);
        this.setLocationRelativeTo(componentParent);
        this.pack();
    }

    private InputPasswordSmartcardDialog(JFrame componentParent, boolean modal, String message, String title, String iconPath, boolean allowUseCache, boolean defaultUseCache) {
        super(componentParent, modal, true);
        this.initComponents(message, title, iconPath, allowUseCache, defaultUseCache);
        this.setLocationRelativeTo(componentParent);
        this.pack();
    }

    protected void initComponents(String message, String title, String iconPath, boolean allowUseCache, boolean defaultUseCache) {
        int maxWidth = this.getMaxWidth();
        int maxHeight = this.getMaxHeight();
        this.setMinimumSize(new Dimension(this.getInitialWidth(), this.getInitialHeight()));
        this.setPreferredSize(new Dimension(this.getInitialWidth(), this.getInitialHeight()));
        this.setMaximumSize(new Dimension(maxWidth, maxHeight));
        if (GeneralConfig.isMaximized()) {
            this.setBounds(0, 0, maxWidth, maxHeight);
        } else if (GeneralConfig.isBigFontSize() || GeneralConfig.isFontBold()) {
            this.setMinimumSize(new Dimension(555, 250));
        }
        this.setTitle(title);
        this.setDefaultCloseOperation(2);
        this.answer = 1;
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        this.mainPanel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(10, 5, 0, 10);
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.setIconLabel(iconPath);
        JPanel iconPanel = new JPanel(new GridBagLayout());
        GridBagConstraints consIconPanel = new GridBagConstraints();
        consIconPanel.fill = 1;
        iconPanel.add((Component)this.iconLabel, consIconPanel);
        this.infoLabel = new InfoLabel(message);
        this.infoLabel.setHorizontalAlignment(2);
        this.infoLabel.setVerticalAlignment(0);
        this.mainPanel.add((Component)this.infoLabel, c);
        this.component = new JSecurePasswordLabel(16);
        ++c.gridy;
        c.insets = new Insets(2, 5, 2, 10);
        this.mainPanel.add((Component)this.component, c);
        if (allowUseCache) {
            this.useCacheCheckBox = new JCheckBox(Messages.getString("InputPasswordSmartcardDialog.useCache"));
            this.useCacheCheckBox.setSelected(defaultUseCache);
            ++c.gridy;
            this.mainPanel.add((Component)this.useCacheCheckBox, c);
        }
        this.createMainButtonsPanel();
        JPanel accessibilityButtonsPanel = this.createAccessibilityButtonsPanel();
        GridBagConstraints cons = new GridBagConstraints();
        cons.fill = 1;
        cons.gridx = 0;
        cons.gridy = 0;
        cons.gridwidth = 2;
        cons.gridheight = 1;
        cons.weighty = 0.0;
        cons.weightx = 0.1;
        container.add((Component)accessibilityButtonsPanel, cons);
        cons.gridx = 2;
        cons.gridy = 0;
        cons.gridwidth = 6;
        cons.gridheight = 2;
        cons.weighty = 0.35;
        cons.weightx = 0.9;
        container.add((Component)this.mainPanel, cons);
        cons.gridx = 0;
        cons.gridy = 1;
        cons.gridwidth = 2;
        cons.gridheight = 3;
        cons.weighty = 0.9;
        cons.weightx = 0.0;
        container.add((Component)iconPanel, cons);
        cons.gridx = 2;
        cons.gridy = 3;
        cons.gridwidth = 6;
        cons.gridheight = 1;
        cons.weighty = 0.65;
        cons.weightx = 0.0;
        container.add((Component)this.buttonsPanel, cons);
        this.pack();
    }

    protected void setIconLabel(String iconPath) {
        if (iconPath != null) {
            ImageIcon icon = new ImageIcon(InputPasswordSmartcardDialog.class.getResource(iconPath));
            Dimension dimensionInicial = new Dimension(100, (int)(100.0f / (float)icon.getIconWidth() * (float)icon.getIconHeight()));
            this.iconLabel.setOriginalIcon(icon);
            this.iconLabel.setOriginalDimension(dimensionInicial);
            this.iconLabel.setIcon(new ImageIcon(icon.getImage().getScaledInstance(dimensionInicial.width, dimensionInicial.height, 4)));
        }
    }

    void createMainButtonsPanel() {
        this.buttonsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints consButtons = new GridBagConstraints();
        consButtons.fill = 0;
        consButtons.gridx = 0;
        consButtons.gridy = 0;
        consButtons.insets = new Insets(0, 10, 0, 10);
        consButtons.anchor = 10;
        JPanel okPanel = new JPanel();
        okButton = this.getButton(Messages.getString("PrincipalGUI.aceptar"), 65);
        okButton.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    InputPasswordSmartcardDialog.getOkButton().doClick();
                } else if (ke.getKeyCode() == 27) {
                    InputPasswordSmartcardDialog.getCancelButton().doClick();
                }
            }
        });
        okPanel.add(okButton);
        this.buttonsPanel.add((Component)okPanel, consButtons);
        okButton.addActionListener(this);
    }

    public static PasswordResult showInputPasswordDialog(Component componentParent, boolean modal, String message, int mnemonic, String title, String iconPath, boolean allowUseCache, boolean defaultUseCache) {
        final InputPasswordSmartcardDialog inputPasswordDialog = InputPasswordSmartcardDialog.getInstanceInputPasswordDialog(componentParent, modal, message, title, iconPath, allowUseCache, defaultUseCache);
        okButton.setEnabled(false);
        inputPasswordDialog.getRootPane().setDefaultButton(null);
        inputPasswordDialog.component.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent ke) {
                int length = inputPasswordDialog.getComponent().getPasswordLength();
                if (length >= 4 && length <= 16) {
                    InputPasswordSmartcardDialog.getOkButton().setEnabled(true);
                    if (ke.getKeyCode() == 10) {
                        InputPasswordSmartcardDialog.getOkButton().doClick();
                    }
                } else {
                    InputPasswordSmartcardDialog.getOkButton().setEnabled(false);
                }
            }

            @Override
            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 27) {
                    InputPasswordSmartcardDialog.getCancelButton().doClick();
                }
            }
        });
        inputPasswordDialog.component.addAncestorListener(new RequestFocusListener());
        AccesibilityUtils.remarcar(inputPasswordDialog.component);
        AccesibilityUtils.setContrastColor(inputPasswordDialog.component);
        AccesibilityUtils.setFontBold(inputPasswordDialog.component);
        inputPasswordDialog.component.getAccessibleContext().setAccessibleName(message.replace("<br>", "") + "  ALT + " + mnemonic + ". ");
        inputPasswordDialog.infoLabel.setLabelFor(inputPasswordDialog.component);
        inputPasswordDialog.infoLabel.setDisplayedMnemonic(mnemonic);
        String text = AccesibilityUtils.remarkMnemonic(inputPasswordDialog.infoLabel.getText(), mnemonic);
        inputPasswordDialog.infoLabel.setText(text);
        if (inputPasswordDialog.useCacheCheckBox != null) {
            inputPasswordDialog.useCacheCheckBox.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent arg0) {
                }

                @Override
                public void keyReleased(KeyEvent arg0) {
                }

                @Override
                public void keyPressed(KeyEvent ke) {
                    if (ke.getKeyCode() == 10) {
                        InputPasswordSmartcardDialog.getOkButton().doClick();
                    } else if (ke.getKeyCode() == 27) {
                        InputPasswordSmartcardDialog.getCancelButton().doClick();
                    }
                }
            });
            AccesibilityUtils.remarcar(inputPasswordDialog.useCacheCheckBox);
            AccesibilityUtils.setContrastColor(inputPasswordDialog.useCacheCheckBox);
            AccesibilityUtils.setFontBold(inputPasswordDialog.useCacheCheckBox);
            inputPasswordDialog.useCacheCheckBox.setMnemonic('e');
            AccesibilityUtils.remarkMnemonic(inputPasswordDialog.useCacheCheckBox, 101);
        }
        GridBagConstraints cons = new GridBagConstraints();
        cons.insets = new Insets(0, 0, 0, 10);
        cancelButton = inputPasswordDialog.getButton(cancellText, 67);
        JPanel cancelPanel = new JPanel();
        cancelPanel.add(cancelButton);
        inputPasswordDialog.buttonsPanel.add((Component)cancelPanel, cons);
        cancelButton.addActionListener(inputPasswordDialog);
        cancelButton.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 10 || ke.getKeyCode() == 27) {
                    InputPasswordSmartcardDialog.getCancelButton().doClick();
                }
            }
        });
        inputPasswordDialog.infoLabel.setHorizontalAlignment(2);
        inputPasswordDialog.component.setVisible(true);
        cancelButton.addActionListener(inputPasswordDialog);
        inputPasswordDialog.pack();
        inputPasswordDialog.setSize(inputPasswordDialog.getInitialWidth() + 1, inputPasswordDialog.getInitialHeight() + 1);
        inputPasswordDialog.setVisible(true);
        if (inputPasswordDialog.getAnswer() == 0) {
            char[] finalPin = inputPasswordDialog.component.getPassword();
            inputPasswordDialog.component.setText("");
            inputPasswordDialog.component.setText(null);
            inputPasswordDialog.component = null;
            inputPasswordDialog.dispose();
            System.gc();
            boolean useCache = false;
            if (inputPasswordDialog.useCacheCheckBox != null) {
                useCache = inputPasswordDialog.useCacheCheckBox.isSelected();
            }
            return new PasswordResult(finalPin, useCache);
        }
        throw new CancelledOperationException("La insercion de contrasena ha sido cancelada por el usuario");
    }

    private JButton getButton(String text, int mnemonic) {
        JButton button = new JButton(text);
        button.setMnemonic(mnemonic);
        AccesibilityUtils.remarcar(button);
        AccesibilityUtils.setContrastColor(button);
        AccesibilityUtils.setFontBold(button);
        if (text.equalsIgnoreCase(cancellText)) {
            String cancelKey = "cancel";
            this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
            this.getRootPane().getActionMap().put("cancel", new AbstractJAccessibilityCustomDialog.ButtonAbstractAction(InputPasswordSmartcardDialog.getCancelButton()));
        }
        return button;
    }

    @Override
    public int getMinimumRelation() {
        return 7;
    }

    private int getAnswer() {
        return this.answer;
    }

    JSecurePasswordLabel getComponent() {
        return this.component;
    }

    static InputPasswordSmartcardDialog getInstanceInputPasswordDialog(Component componentParent, boolean modal, String message, String title, String iconPath, boolean allowUseCache, boolean defaultUseCache) {
        return new InputPasswordSmartcardDialog(componentParent, modal, message, title, iconPath, allowUseCache, defaultUseCache);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.answer = e.getSource().equals(okButton) ? 0 : 2;
        this.setVisible(false);
    }
}

