/*
 * Decompiled with CFR 0.152.
 */
package es.gob.jmulticard.ui.passwordcallback.gui;

import es.gob.jmulticard.CancelledOperationException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import javax.security.auth.callback.PasswordCallback;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public final class UIPasswordCallbackCan
extends PasswordCallback {
    private static final long serialVersionUID = 1719174318602363633L;
    private static final String CAN_EXAMPLE = "/images/can_example.png";
    private final transient String message;
    private final transient Component parent;
    private final transient String title;

    public UIPasswordCallbackCan(String prompt, Object parentComponent, String dialogMessage, String dialogTitle) {
        super(prompt, false);
        this.parent = parentComponent instanceof Component ? (Component)parentComponent : null;
        this.message = prompt != null ? prompt : dialogMessage;
        this.title = dialogTitle;
    }

    @Override
    public char[] getPassword() {
        final JPasswordField pwd = new JPasswordField(10);
        JLabel lbText = new JLabel(this.message);
        lbText.setMinimumSize(new Dimension(lbText.getFontMetrics(lbText.getFont()).stringWidth(this.message), lbText.getSize().height));
        lbText.setLabelFor(pwd);
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.anchor = 10;
        panel.add((Component)lbText, constraints);
        ++constraints.gridy;
        ++constraints.gridy;
        ++constraints.gridy;
        constraints.insets = new Insets(20, 0, 0, 20);
        panel.add((Component)pwd, constraints);
        ++constraints.gridy;
        ++constraints.gridy;
        ++constraints.gridy;
        ImageIcon icon = new ImageIcon(this.getClass().getResource(CAN_EXAMPLE));
        Image image = icon.getImage().getScaledInstance(230, 140, 4);
        icon.setImage(image);
        boolean borderWidth = true;
        boolean spaceAroundIcon = false;
        Color borderColor = Color.LIGHT_GRAY;
        BufferedImage bi = new BufferedImage(icon.getIconWidth() + 2 + 0, icon.getIconHeight() + 2 + 0, 2);
        Graphics2D g = bi.createGraphics();
        g.setColor(borderColor);
        g.drawImage(icon.getImage(), 1, 1, null);
        BasicStroke stroke = new BasicStroke(5.0f);
        g.setStroke(stroke);
        g.drawRect(0, 0, bi.getWidth() - 1, bi.getHeight() - 1);
        g.dispose();
        JLabel label = new JLabel(new ImageIcon(bi), 2);
        label.setVerticalAlignment(1);
        label.setHorizontalAlignment(0);
        panel.add((Component)label, constraints);
        ++constraints.gridy;
        ++constraints.gridy;
        ++constraints.gridy;
        JOptionPane pane = new JOptionPane(panel, -1, 2){
            private static final long serialVersionUID = -3012522768561175760L;

            @Override
            public void selectInitialValue() {
                pwd.requestFocusInWindow();
            }
        };
        pane.setPreferredSize(new Dimension(350, 310));
        pane.createDialog(this.parent, this.title).setVisible(true);
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            return new char[0];
        }
        if ((Integer)selectedValue == 0) {
            return pwd.getPassword();
        }
        throw new CancelledOperationException("La insercion de contrasena ha sido cancelada por el usuario");
    }
}

