/*
 * Decompiled with CFR 0.152.
 */
package fun.fengwk.chatjava.core.agent;

import fun.fengwk.chatjava.core.agent.Agent;
import fun.fengwk.chatjava.core.agent.Answer;
import fun.fengwk.chatjava.core.agent.AnswerListener;
import fun.fengwk.chatjava.core.client.ChatCompletionsResponse;
import fun.fengwk.chatjava.core.client.StreamChatListener;
import fun.fengwk.chatjava.core.client.util.ChatUtils;
import java.util.Objects;

public class AnswerListenerAdapter
implements StreamChatListener {
    private final Agent agent;
    private final AnswerListener answerListener;

    public AnswerListenerAdapter(Agent agent, AnswerListener answerListener) {
        this.agent = Objects.requireNonNull(agent);
        this.answerListener = Objects.requireNonNull(answerListener);
    }

    @Override
    public void onReceive(ChatCompletionsResponse response) {
        if (response.isSuccess()) {
            Answer answer = new Answer();
            answer.setAgent(this.agent);
            answer.setContent(ChatUtils.getContent(response.getChatResponse()));
            this.answerListener.onReceive(answer);
        }
    }

    @Override
    public void onError(Throwable throwable) {
        this.answerListener.onError(throwable);
    }

    @Override
    public void onComplete() {
        this.answerListener.onComplete();
    }
}

