/*
 * Decompiled with CFR 0.152.
 */
package fun.fengwk.chatjava.core.agent;

import fun.fengwk.chatjava.core.agent.Agent;
import fun.fengwk.chatjava.core.agent.AgentEngine;
import fun.fengwk.chatjava.core.agent.Answer;
import fun.fengwk.chatjava.core.agent.AnswerListener;
import fun.fengwk.chatjava.core.agent.AnswerListenerAdapter;
import fun.fengwk.chatjava.core.agent.ChatModelParameters;
import fun.fengwk.chatjava.core.agent.MemoryRecord;
import fun.fengwk.chatjava.core.agent.MemorySession;
import fun.fengwk.chatjava.core.agent.Question;
import fun.fengwk.chatjava.core.client.ChatClient;
import fun.fengwk.chatjava.core.client.ChatClientProvider;
import fun.fengwk.chatjava.core.client.ChatCompletionsResponse;
import fun.fengwk.chatjava.core.client.request.ChatMessage;
import fun.fengwk.chatjava.core.client.request.ChatRequest;
import fun.fengwk.chatjava.core.client.response.ChatResponse;
import fun.fengwk.chatjava.core.client.response.ChatUsage;
import fun.fengwk.chatjava.core.client.token.ChatTokenizer;
import fun.fengwk.chatjava.core.client.util.ChatMiscUtils;
import fun.fengwk.chatjava.core.client.util.ChatUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChatClientAgentEngine
implements AgentEngine {
    private static final Logger log = LoggerFactory.getLogger(ChatClientAgentEngine.class);
    private final ChatClientProvider chatClientProvider;
    private final ChatTokenizer chatTokenizer;

    public ChatClientAgentEngine(ChatClientProvider chatClientProvider, ChatTokenizer chatTokenizer) {
        this.chatClientProvider = Objects.requireNonNull(chatClientProvider);
        this.chatTokenizer = chatTokenizer;
    }

    @Override
    public Answer ask(Agent agent, Question question, MemorySession memorySession) {
        this.checkAgent(agent);
        this.checkQuestion(question);
        this.checkMemorySession(memorySession);
        ChatClient chatGptClient = this.chatClientProvider.getChatClientWithTools(agent.getTools());
        ChatRequest chatRequest = new ChatRequest();
        chatRequest.setModel(agent.getModel());
        chatRequest.setMessages(this.buildMessages(agent, question, memorySession));
        ChatModelParameters modelParameters = ChatModelParameters.fromMap(agent.getModelParameters());
        this.setChatGptParameters(chatRequest, modelParameters);
        ChatCompletionsResponse response = chatGptClient.chatCompletions(chatRequest);
        if (!response.isSuccess()) {
            log.error("ask error, agent: {}, question: {}, response: {}", new Object[]{agent, question, response});
            throw response.toRuntimeException();
        }
        ChatResponse chatResponse = response.getChatResponse();
        ChatMessage message = ChatUtils.getMessage(chatResponse);
        ChatUsage usage = chatResponse.getUsage();
        Answer answer = new Answer();
        answer.setAgent(agent);
        answer.setContent(message.getContent());
        memorySession.append(agent.getName(), "user", question.getContent(), usage.getPrompt_tokens());
        memorySession.append(message.getName(), message.getRole(), message.getContent(), usage.getCompletion_tokens());
        return answer;
    }

    @Override
    public CompletableFuture<Answer> streamAsk(Agent agent, Question question, MemorySession memorySession, AnswerListener answerListener) {
        this.checkAgent(agent);
        this.checkQuestion(question);
        this.checkMemorySession(memorySession);
        this.checkAnswerListener(answerListener);
        ChatClient chatGptClient = this.chatClientProvider.getChatClientWithTools(agent.getTools());
        ChatRequest chatRequest = new ChatRequest();
        chatRequest.setModel(agent.getModel());
        chatRequest.setMessages(this.buildMessages(agent, question, memorySession));
        ChatModelParameters modelParameters = ChatModelParameters.fromMap(agent.getModelParameters());
        if (agent.getMaxTokens() != null) {
            chatRequest.setMax_tokens(agent.getMaxTokens());
        }
        this.setChatGptParameters(chatRequest, modelParameters);
        return chatGptClient.streamChatCompletions(chatRequest, new AnswerListenerAdapter(agent, answerListener)).thenApply(response -> {
            if (!response.isSuccess()) {
                log.error("streamAsk error, agent: {}, question: {}, response: {}", new Object[]{agent, question, response});
                throw response.toRuntimeException();
            }
            ChatResponse chatResponse = response.getChatResponse();
            ChatMessage message = ChatUtils.getMessage(chatResponse);
            ChatUsage usage = chatResponse.getUsage();
            Answer answer = new Answer();
            answer.setAgent(agent);
            answer.setContent(ChatUtils.getContent(chatResponse));
            memorySession.append(agent.getName(), "user", question.getContent(), usage.getPrompt_tokens());
            memorySession.append(message.getName(), message.getRole(), message.getContent(), usage.getCompletion_tokens());
            return answer;
        });
    }

    private void checkAgent(Agent agent) {
        if (agent == null) {
            throw new IllegalArgumentException("agent must not be null");
        }
        if (ChatMiscUtils.isEmpty(agent.getModel())) {
            throw new IllegalArgumentException("agent.model must not be empty");
        }
    }

    private void checkQuestion(Question question) {
        if (question == null) {
            throw new IllegalArgumentException("question must not be null");
        }
        if (ChatMiscUtils.isEmpty(question.getContent())) {
            throw new IllegalArgumentException("question.content must not be empty");
        }
    }

    private void checkMemorySession(MemorySession memorySession) {
        if (memorySession == null) {
            throw new IllegalArgumentException("memorySession must not be null");
        }
    }

    private void checkAnswerListener(AnswerListener answerListener) {
        if (answerListener == null) {
            throw new IllegalArgumentException("answerListener must not be null");
        }
    }

    private void setChatGptParameters(ChatRequest chatRequest, ChatModelParameters modelParameters) {
        chatRequest.setTemperature(modelParameters.getTemperature());
        chatRequest.setTop_p(modelParameters.getTopP());
        chatRequest.setPresence_penalty(modelParameters.getPresencePenalty());
        chatRequest.setFrequency_penalty(modelParameters.getFrequencyPenalty());
    }

    private List<ChatMessage> buildMessages(Agent agent, Question question, MemorySession memorySession) {
        ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
        if (ChatMiscUtils.isNotEmpty(agent.getPrompt())) {
            messages.add(ChatMessage.newSystemMessage(agent.getPrompt()));
        }
        if (!this.chatTokenizer.support(agent.getModel())) {
            throw new IllegalStateException(String.format("current tokenizer [%s] can not support model: %s", this.chatTokenizer, agent.getModel()));
        }
        List<MemoryRecord> allMemorySequence = memorySession.getAllMemorySequence();
        for (MemoryRecord memoryRecord : allMemorySequence) {
            if (Objects.equals(memoryRecord.getSpeakerRole(), "user")) {
                messages.add(ChatMessage.newUserMessage(memoryRecord.getContent(), memoryRecord.getSpeaker()));
                continue;
            }
            messages.add(ChatMessage.newAssistantMessage(memoryRecord.getContent()));
        }
        messages.add(ChatMessage.newUserMessage(question.getContent(), agent.getName()));
        return messages;
    }
}

