/*
 * Decompiled with CFR 0.152.
 */
package fun.fengwk.chatjava.core.agent;

import java.util.HashMap;
import java.util.Map;

public class ChatModelParameters {
    private static final String TEMPERATURE = "temperature";
    private static final String TOP_P = "topP";
    private static final String PRESENCE_PENALTY = "presencePenalty";
    private static final String FREQUENCY_PENALTY = "frequencyPenalty";
    private Float temperature;
    private Float topP;
    private Float presencePenalty;
    private Float frequencyPenalty;

    public static ChatModelParameters fromMap(Map<String, Object> map) {
        ChatModelParameters parameters = new ChatModelParameters();
        if (map != null) {
            parameters.setTemperature(ChatModelParameters.toChatGptParameter(map.get(TEMPERATURE)));
            parameters.setTopP(ChatModelParameters.toChatGptParameter(map.get(TOP_P)));
            parameters.setPresencePenalty(ChatModelParameters.toChatGptParameter(map.get(PRESENCE_PENALTY)));
            parameters.setFrequencyPenalty(ChatModelParameters.toChatGptParameter(map.get(FREQUENCY_PENALTY)));
        }
        return parameters;
    }

    private static Float toChatGptParameter(Object p) {
        if (p instanceof Number) {
            return Float.valueOf(((Number)p).floatValue());
        }
        return null;
    }

    public Map<String, Object> asMap() {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        if (this.getTemperature() != null) {
            parameterMap.put(TEMPERATURE, this.getTemperature());
        }
        if (this.getTopP() != null) {
            parameterMap.put(TOP_P, this.getTopP());
        }
        if (this.getPresencePenalty() != null) {
            parameterMap.put(PRESENCE_PENALTY, this.getPresencePenalty());
        }
        if (this.getFrequencyPenalty() != null) {
            parameterMap.put(FREQUENCY_PENALTY, this.getFrequencyPenalty());
        }
        return parameterMap;
    }

    public Float getTemperature() {
        return this.temperature;
    }

    public Float getTopP() {
        return this.topP;
    }

    public Float getPresencePenalty() {
        return this.presencePenalty;
    }

    public Float getFrequencyPenalty() {
        return this.frequencyPenalty;
    }

    public void setTemperature(Float temperature) {
        this.temperature = temperature;
    }

    public void setTopP(Float topP) {
        this.topP = topP;
    }

    public void setPresencePenalty(Float presencePenalty) {
        this.presencePenalty = presencePenalty;
    }

    public void setFrequencyPenalty(Float frequencyPenalty) {
        this.frequencyPenalty = frequencyPenalty;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatModelParameters)) {
            return false;
        }
        ChatModelParameters other = (ChatModelParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Float this$temperature = this.getTemperature();
        Float other$temperature = other.getTemperature();
        if (this$temperature == null ? other$temperature != null : !((Object)this$temperature).equals(other$temperature)) {
            return false;
        }
        Float this$topP = this.getTopP();
        Float other$topP = other.getTopP();
        if (this$topP == null ? other$topP != null : !((Object)this$topP).equals(other$topP)) {
            return false;
        }
        Float this$presencePenalty = this.getPresencePenalty();
        Float other$presencePenalty = other.getPresencePenalty();
        if (this$presencePenalty == null ? other$presencePenalty != null : !((Object)this$presencePenalty).equals(other$presencePenalty)) {
            return false;
        }
        Float this$frequencyPenalty = this.getFrequencyPenalty();
        Float other$frequencyPenalty = other.getFrequencyPenalty();
        return !(this$frequencyPenalty == null ? other$frequencyPenalty != null : !((Object)this$frequencyPenalty).equals(other$frequencyPenalty));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatModelParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Float $temperature = this.getTemperature();
        result = result * 59 + ($temperature == null ? 43 : ((Object)$temperature).hashCode());
        Float $topP = this.getTopP();
        result = result * 59 + ($topP == null ? 43 : ((Object)$topP).hashCode());
        Float $presencePenalty = this.getPresencePenalty();
        result = result * 59 + ($presencePenalty == null ? 43 : ((Object)$presencePenalty).hashCode());
        Float $frequencyPenalty = this.getFrequencyPenalty();
        result = result * 59 + ($frequencyPenalty == null ? 43 : ((Object)$frequencyPenalty).hashCode());
        return result;
    }

    public String toString() {
        return "ChatModelParameters(temperature=" + this.getTemperature() + ", topP=" + this.getTopP() + ", presencePenalty=" + this.getPresencePenalty() + ", frequencyPenalty=" + this.getFrequencyPenalty() + ")";
    }
}

