/*
 * Decompiled with CFR 0.152.
 */
package fun.fengwk.chatjava.core.agent;

import fun.fengwk.chatjava.core.agent.MemoryRecord;
import fun.fengwk.chatjava.core.agent.MemorySession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

public class InJvmMemorySession
implements MemorySession {
    private final String sessionId;
    private final List<MemoryRecord> records = new ArrayList<MemoryRecord>();
    private long seqNoCounter = 0L;

    public InJvmMemorySession() {
        this(UUID.randomUUID().toString().replaceAll("-", ""));
    }

    public InJvmMemorySession(String sessionId) {
        this.sessionId = Objects.requireNonNull(sessionId);
    }

    @Override
    public String getSessionId() {
        return this.sessionId;
    }

    @Override
    public synchronized MemoryRecord append(String speaker, String speakerRole, String content, int tokenCount) {
        MemoryRecord record = new MemoryRecord();
        record.setSessionId(this.getSessionId());
        record.setSequenceNo(this.seqNoCounter++);
        record.setSpeaker(speaker);
        record.setSpeakerRole(speakerRole);
        record.setContent(content);
        record.setTokenCount(tokenCount);
        this.records.add(record);
        return record;
    }

    @Override
    public synchronized List<MemoryRecord> getLatestMemorySequence(int maxTokens) {
        MemoryRecord record;
        LinkedList<MemoryRecord> latestMemorySequence = new LinkedList<MemoryRecord>();
        for (int i = this.records.size() - 1; i >= 0 && maxTokens - (record = this.records.get(i)).getTokenCount() >= 0; --i) {
            maxTokens -= record.getTokenCount().intValue();
            latestMemorySequence.addFirst(record);
        }
        return latestMemorySequence;
    }

    @Override
    public synchronized List<MemoryRecord> getAllMemorySequence() {
        return Collections.unmodifiableList(this.records);
    }
}

