/*
 * Decompiled with CFR 0.152.
 */
package fun.fengwk.chatjava.core.client;

import fun.fengwk.chatjava.core.client.ChatClient;
import fun.fengwk.chatjava.core.client.ChatClientOptions;
import fun.fengwk.chatjava.core.client.ChatClientProvider;
import fun.fengwk.chatjava.core.client.HttpClientChatClient;
import fun.fengwk.chatjava.core.client.tool.DefaultToolFunctionHandlerRegistry;
import fun.fengwk.chatjava.core.client.tool.ToolChatClient;
import fun.fengwk.chatjava.core.client.tool.ToolFunctionHandlerRegistry;
import fun.fengwk.chatjava.core.client.tool.ToolFunctionHandlerRegistrySubView;
import fun.fengwk.chatjava.core.client.util.ChatMiscUtils;
import java.net.http.HttpClient;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractChatClientProvider
implements ChatClientProvider {
    private final ToolFunctionHandlerRegistry toolFunctionHandlerRegistry;

    public AbstractChatClientProvider() {
        this(new DefaultToolFunctionHandlerRegistry());
    }

    public AbstractChatClientProvider(ToolFunctionHandlerRegistry toolFunctionHandlerRegistry) {
        this.toolFunctionHandlerRegistry = Objects.requireNonNull(toolFunctionHandlerRegistry);
    }

    public ToolFunctionHandlerRegistry getToolFunctionHandlerRegistry() {
        return this.toolFunctionHandlerRegistry;
    }

    protected abstract ChatClientOptions getDefaultChatClientOptions();

    protected abstract HttpClient getHttpClient();

    @Override
    public ChatClient getChatClient() {
        return this.getChatClient(this.getDefaultChatClientOptions());
    }

    @Override
    public ChatClient getChatClient(ChatClientOptions clientOptions) {
        return new HttpClientChatClient(clientOptions, this.getHttpClient());
    }

    @Override
    public ChatClient getChatClientWithTools() {
        return this.getChatClientWithTools(this.getSupportTools(), this.getDefaultChatClientOptions());
    }

    @Override
    public ChatClient getChatClientWithTools(Collection<String> tools) {
        return this.getChatClientWithTools(tools, this.getDefaultChatClientOptions());
    }

    @Override
    public ChatClient getChatClientWithTools(Collection<String> tools, ChatClientOptions clientOptions) {
        if (ChatMiscUtils.isEmpty(tools)) {
            return this.getChatClient(clientOptions);
        }
        ChatClient chatGptClient = new HttpClientChatClient(clientOptions, this.getHttpClient());
        chatGptClient = new ToolChatClient(chatGptClient, new ToolFunctionHandlerRegistrySubView(this.toolFunctionHandlerRegistry, tools));
        return chatGptClient;
    }

    @Override
    public Set<String> getSupportTools() {
        return this.toolFunctionHandlerRegistry.getAllNames();
    }
}

