/*
 * Decompiled with CFR 0.152.
 */
package fun.fengwk.chatjava.core.client;

import fun.fengwk.chatjava.core.client.ChatCompletionsResponse;
import fun.fengwk.chatjava.core.client.StreamChatListener;
import fun.fengwk.chatjava.core.client.request.ChatMessage;
import fun.fengwk.chatjava.core.client.response.ChatChoice;
import fun.fengwk.chatjava.core.client.response.ChatResponse;
import fun.fengwk.chatjava.core.client.response.ChatToolCall;
import fun.fengwk.chatjava.core.client.response.ChatToolCallFunction;
import fun.fengwk.chatjava.core.client.util.ChatMiscUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CompleteResponseStreamChatListener
implements StreamChatListener {
    protected volatile ChatCompletionsResponse response;
    protected volatile ChatResponse chatResponse;
    protected volatile Throwable error;
    protected volatile boolean complete;

    public ChatCompletionsResponse toChatCompletionsResponse() {
        if (this.response != null) {
            return this.response;
        }
        if (this.error != null) {
            return new ChatCompletionsResponse(false, null, this.error.getMessage(), this.error);
        }
        if (this.complete) {
            if (this.chatResponse != null) {
                return new ChatCompletionsResponse(true, this.chatResponse, null, null);
            }
            IllegalStateException ex = new IllegalStateException("chatResponse is empty");
            return new ChatCompletionsResponse(false, null, ex.getMessage(), ex);
        }
        IllegalStateException ex = new IllegalStateException("chatResponse not complete");
        return new ChatCompletionsResponse(false, null, ex.getMessage(), ex);
    }

    @Override
    public void onReceive(ChatCompletionsResponse response) {
        if (response.isSuccess()) {
            if (this.chatResponse == null) {
                this.chatResponse = response.getChatResponse();
            } else {
                this.mergeResponse(this.chatResponse, response.getChatResponse());
            }
        } else {
            this.response = response;
        }
    }

    @Override
    public void onError(Throwable throwable) {
        this.error = throwable;
    }

    @Override
    public void onComplete() {
        this.complete = true;
    }

    private void mergeResponse(ChatResponse to, ChatResponse from) {
        if (to == null || from == null) {
            return;
        }
        this.mergeProperty(to, from, ChatResponse::getId, ChatResponse::setId);
        if (!this.mergeProperty(to, from, ChatResponse::getChoices, ChatResponse::setChoices)) {
            to.setChoices(this.mergeChoices(to.getChoices(), from.getChoices()));
        }
        this.mergeProperty(to, from, ChatResponse::getCreated, ChatResponse::setCreated);
        this.mergeProperty(to, from, ChatResponse::getModel, ChatResponse::setModel);
        this.mergeProperty(to, from, ChatResponse::getSystem_fingerprint, ChatResponse::setSystem_fingerprint);
        this.mergeProperty(to, from, ChatResponse::getObject, ChatResponse::setObject);
        this.mergeProperty(to, from, ChatResponse::getUsage, ChatResponse::setUsage);
    }

    private List<ChatChoice> mergeChoices(List<ChatChoice> to, List<ChatChoice> from) {
        to = ChatMiscUtils.nullSafe(to, ArrayList::new);
        Set toIndexes = to.stream().map(ChatChoice::getIndex).collect(Collectors.toSet());
        Map fromMap = ChatMiscUtils.nullSafe(from).stream().collect(Collectors.toMap(ChatChoice::getIndex, Function.identity()));
        for (Integer fromIndex : new HashSet<Integer>(fromMap.keySet())) {
            if (toIndexes.contains(fromIndex)) continue;
            to.add((ChatChoice)fromMap.get(fromIndex));
            fromMap.remove(fromIndex);
        }
        for (int i = 0; i < to.size(); ++i) {
            ChatChoice cto = to.get(i);
            ChatChoice cfrom = (ChatChoice)fromMap.get(cto.getIndex());
            if (cfrom == null) continue;
            this.mergeChoice(cto, cfrom);
        }
        to.sort(Comparator.comparing(ChatChoice::getIndex));
        return to;
    }

    private void mergeChoice(ChatChoice to, ChatChoice from) {
        if (to == null || from == null) {
            return;
        }
        this.mergeProperty(to, from, ChatChoice::getFinish_reason, ChatChoice::setFinish_reason);
        this.mergeProperty(to, from, ChatChoice::getIndex, ChatChoice::setIndex);
        if (!this.mergeProperty(to, from, ChatChoice::getMessage, ChatChoice::setMessage)) {
            this.mergeMessage(to.getMessage(), from.getMessage());
        }
        if (!this.mergeProperty(to, from, ChatChoice::getDelta, ChatChoice::setDelta)) {
            this.mergeMessage(to.getDelta(), from.getDelta());
        }
        this.mergeProperty(to, from, ChatChoice::getLogprobs, ChatChoice::setLogprobs);
    }

    private void mergeMessage(ChatMessage to, ChatMessage from) {
        if (to == null || from == null) {
            return;
        }
        to.setContent(ChatMiscUtils.nullSafe(to.getContent()) + ChatMiscUtils.nullSafe(from.getContent()));
        to.setReasoning_content(ChatMiscUtils.nullSafe(to.getReasoning_content()) + ChatMiscUtils.nullSafe(from.getReasoning_content()));
        this.mergeProperty(to, from, ChatMessage::getRole, ChatMessage::setRole);
        this.mergeProperty(to, from, ChatMessage::getName, ChatMessage::setName);
        this.mergeProperty(to, from, ChatMessage::getTool_call_id, ChatMessage::setTool_call_id);
        if (!this.mergeProperty(to, from, ChatMessage::getTool_calls, ChatMessage::setTool_calls)) {
            to.setTool_calls(this.mergeToolCalls(to.getTool_calls(), from.getTool_calls()));
        }
        if (!this.mergeProperty(to, from, ChatMessage::getFunction_call, ChatMessage::setFunction_call)) {
            this.mergeChatToolCallFunction(to.getFunction_call(), from.getFunction_call());
        }
    }

    private List<ChatToolCall> mergeToolCalls(List<ChatToolCall> to, List<ChatToolCall> from) {
        to = ChatMiscUtils.nullSafe(to, ArrayList::new);
        from = ChatMiscUtils.nullSafe(from, ArrayList::new);
        for (int i = 0; i < from.size(); ++i) {
            ChatToolCall cfrom = from.get(i);
            if (to.isEmpty() || ChatMiscUtils.isNotEmpty(cfrom.getId())) {
                to.add(cfrom);
                continue;
            }
            this.mergeToolCall(ChatMiscUtils.tryGetLast(to), cfrom);
        }
        return to;
    }

    private void mergeToolCall(ChatToolCall to, ChatToolCall from) {
        if (to == null || from == null) {
            return;
        }
        this.mergeProperty(to, from, ChatToolCall::getId, ChatToolCall::setId);
        this.mergeProperty(to, from, ChatToolCall::getType, ChatToolCall::setType);
        if (!this.mergeProperty(to, from, ChatToolCall::getFunction, ChatToolCall::setFunction)) {
            this.mergeChatToolCallFunction(to.getFunction(), from.getFunction());
        }
    }

    private void mergeChatToolCallFunction(ChatToolCallFunction to, ChatToolCallFunction from) {
        if (to == null || from == null) {
            return;
        }
        this.mergeProperty(to, from, ChatToolCallFunction::getName, ChatToolCallFunction::setName);
        to.setArguments(ChatMiscUtils.nullSafe(to.getArguments()) + ChatMiscUtils.nullSafe(from.getArguments()));
    }

    private <T, P> boolean mergeProperty(T to, T from, Function<T, P> getter, BiConsumer<T, P> setter) {
        if (getter.apply(to) == null && getter.apply(from) != null) {
            setter.accept(to, getter.apply(from));
            return true;
        }
        return false;
    }

    public ChatCompletionsResponse getResponse() {
        return this.response;
    }

    public ChatResponse getChatResponse() {
        return this.chatResponse;
    }

    public Throwable getError() {
        return this.error;
    }

    public boolean isComplete() {
        return this.complete;
    }
}

