/*
 * Decompiled with CFR 0.152.
 */
package fun.fengwk.chatjava.core.client;

import fun.fengwk.chatjava.core.client.ChatClient;
import fun.fengwk.chatjava.core.client.ChatClientOptions;
import fun.fengwk.chatjava.core.client.ChatCompletionsResponse;
import fun.fengwk.chatjava.core.client.CompleteResponseStreamChatListenerDecorator;
import fun.fengwk.chatjava.core.client.StreamChatListener;
import fun.fengwk.chatjava.core.client.StreamChatListenerAdapter;
import fun.fengwk.chatjava.core.client.request.ChatRequest;
import fun.fengwk.chatjava.core.client.response.ChatResponse;
import fun.fengwk.chatjava.core.client.util.ChatUtils;
import fun.fengwk.chatjava.core.client.util.httpclient.ChatHttpClientFactory;
import fun.fengwk.chatjava.core.client.util.httpclient.ChatHttpClientUtils;
import fun.fengwk.chatjava.core.client.util.json.ChatJsonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientChatClient
implements ChatClient {
    private static final Logger log = LoggerFactory.getLogger(HttpClientChatClient.class);
    private volatile ChatClientOptions clientOptions;
    private final HttpClient httpClient;

    public HttpClientChatClient(ChatClientOptions chatClientOptions) {
        this(chatClientOptions, ChatHttpClientFactory.getDefaultHttpClient());
    }

    public HttpClientChatClient(ChatClientOptions clientOptions, HttpClient httpClient) {
        this.clientOptions = clientOptions;
        this.httpClient = httpClient;
    }

    @Override
    public ChatClientOptions getClientOptions() {
        return this.clientOptions;
    }

    @Override
    public void setClientOptions(ChatClientOptions clientOptions) {
        this.clientOptions = clientOptions;
    }

    @Override
    public ChatCompletionsResponse chatCompletions(ChatRequest chatRequest, ChatClientOptions clientOptions) {
        Exception error;
        String errorMessage;
        HttpRequest httpRequest = this.buildChatCompletionHttpRequest(chatRequest, clientOptions);
        try {
            log.debug("chatCompletions request, url: {}, chatRequest: {}", (Object)clientOptions.getChatCompletionsUrl(), (Object)ChatJsonUtils.toJson(chatRequest));
            HttpResponse<InputStream> httpResponse = this.httpClient.send(httpRequest, HttpResponse.BodyHandlers.ofInputStream());
            String respBody = ChatHttpClientUtils.parseBodyString(httpResponse);
            if (ChatHttpClientUtils.success(httpResponse.statusCode())) {
                log.debug("chatCompletions response success, respBody: {}", (Object)respBody);
                try {
                    ChatResponse chatResponse = ChatJsonUtils.fromJson(respBody, ChatResponse.class);
                    return new ChatCompletionsResponse(true, chatResponse, null, null);
                }
                catch (Exception ex) {
                    errorMessage = respBody;
                    error = ex;
                }
            } else {
                log.error("ChatClient.chatCompletions failed, status: {}, body: {}", (Object)httpResponse.statusCode(), (Object)respBody);
                errorMessage = respBody;
                error = new IllegalStateException("chatCompletions http status: " + httpResponse.statusCode());
            }
        }
        catch (IOException ex) {
            errorMessage = ex.getMessage();
            error = ex;
            log.error("ChatClient.chatCompletions failed", (Throwable)ex);
        }
        catch (InterruptedException ex) {
            errorMessage = ex.getMessage();
            error = ex;
            log.warn("ChatClient.chatCompletions interrupted");
            Thread.currentThread().interrupt();
        }
        return new ChatCompletionsResponse(false, null, errorMessage, error);
    }

    @Override
    public CompletableFuture<ChatCompletionsResponse> streamChatCompletions(ChatRequest chatRequest, StreamChatListener chatListener, ChatClientOptions clientOptions) {
        chatRequest.setStream(true);
        ChatUtils.streamIncludeUsage(chatRequest);
        HttpRequest httpRequest = this.buildChatCompletionHttpRequest(chatRequest, clientOptions);
        log.debug("streamChatCompletions request, url: {}, chatRequest: {}", (Object)clientOptions.getChatCompletionsUrl(), (Object)ChatJsonUtils.toJson(chatRequest));
        CompleteResponseStreamChatListenerDecorator completeChatListener = new CompleteResponseStreamChatListenerDecorator(chatListener);
        return this.httpClient.sendAsync(httpRequest, HttpResponse.BodyHandlers.fromLineSubscriber(new StreamChatListenerAdapter(completeChatListener))).thenApply(resp -> completeChatListener.toChatCompletionsResponse());
    }

    private HttpRequest buildChatCompletionHttpRequest(ChatRequest chatRequest, ChatClientOptions clientOptions) {
        String reqBody = ChatJsonUtils.toJson(chatRequest);
        HttpRequest.BodyPublisher bodyPublisher = HttpRequest.BodyPublishers.ofString(reqBody, StandardCharsets.UTF_8);
        return HttpRequest.newBuilder().uri(clientOptions.getChatCompletionsUrl()).POST(bodyPublisher).header("Content-Type", "application/json").header("Authorization", "Bearer " + clientOptions.getToken()).timeout(clientOptions.getPerHttpRequestTimeout()).build();
    }
}

