/*
 * Decompiled with CFR 0.152.
 */
package fun.fengwk.chatjava.core.client.request;

import fun.fengwk.chatjava.core.client.response.ChatToolCall;
import fun.fengwk.chatjava.core.client.response.ChatToolCallFunction;
import java.util.List;

public class ChatMessage {
    public static final String ROLE_SYSTEM = "system";
    public static final String ROLE_USER = "user";
    public static final String ROLE_ASSISTANT = "assistant";
    public static final String ROLE_TOOL = "tool";
    private String content;
    private String reasoning_content;
    private String role;
    private String name;
    private String tool_call_id;
    private List<ChatToolCall> tool_calls;
    @Deprecated
    private ChatToolCallFunction function_call;

    public static ChatMessage newSystemMessage(String content) {
        ChatMessage message = new ChatMessage();
        message.setContent(content);
        message.setRole(ROLE_SYSTEM);
        return message;
    }

    public static ChatMessage newUserMessage(String content) {
        return ChatMessage.newUserMessage(content, null);
    }

    public static ChatMessage newUserMessage(String content, String name) {
        ChatMessage message = new ChatMessage();
        message.setContent(content);
        message.setName(name);
        message.setRole(ROLE_USER);
        return message;
    }

    public static ChatMessage newAssistantMessage(String content) {
        ChatMessage message = new ChatMessage();
        message.setContent(content);
        message.setRole(ROLE_ASSISTANT);
        return message;
    }

    public static ChatMessage newToolMessage(String toolCallId, String content) {
        ChatMessage message = new ChatMessage();
        message.setTool_call_id(toolCallId);
        message.setContent(content);
        message.setRole(ROLE_TOOL);
        return message;
    }

    public String getContent() {
        return this.content;
    }

    public String getReasoning_content() {
        return this.reasoning_content;
    }

    public String getRole() {
        return this.role;
    }

    public String getName() {
        return this.name;
    }

    public String getTool_call_id() {
        return this.tool_call_id;
    }

    public List<ChatToolCall> getTool_calls() {
        return this.tool_calls;
    }

    @Deprecated
    public ChatToolCallFunction getFunction_call() {
        return this.function_call;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setReasoning_content(String reasoning_content) {
        this.reasoning_content = reasoning_content;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTool_call_id(String tool_call_id) {
        this.tool_call_id = tool_call_id;
    }

    public void setTool_calls(List<ChatToolCall> tool_calls) {
        this.tool_calls = tool_calls;
    }

    @Deprecated
    public void setFunction_call(ChatToolCallFunction function_call) {
        this.function_call = function_call;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatMessage)) {
            return false;
        }
        ChatMessage other = (ChatMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$reasoning_content = this.getReasoning_content();
        String other$reasoning_content = other.getReasoning_content();
        if (this$reasoning_content == null ? other$reasoning_content != null : !this$reasoning_content.equals(other$reasoning_content)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$tool_call_id = this.getTool_call_id();
        String other$tool_call_id = other.getTool_call_id();
        if (this$tool_call_id == null ? other$tool_call_id != null : !this$tool_call_id.equals(other$tool_call_id)) {
            return false;
        }
        List<ChatToolCall> this$tool_calls = this.getTool_calls();
        List<ChatToolCall> other$tool_calls = other.getTool_calls();
        if (this$tool_calls == null ? other$tool_calls != null : !((Object)this$tool_calls).equals(other$tool_calls)) {
            return false;
        }
        ChatToolCallFunction this$function_call = this.getFunction_call();
        ChatToolCallFunction other$function_call = other.getFunction_call();
        return !(this$function_call == null ? other$function_call != null : !((Object)this$function_call).equals(other$function_call));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ChatMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $reasoning_content = this.getReasoning_content();
        result = result * 59 + ($reasoning_content == null ? 43 : $reasoning_content.hashCode());
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $tool_call_id = this.getTool_call_id();
        result = result * 59 + ($tool_call_id == null ? 43 : $tool_call_id.hashCode());
        List<ChatToolCall> $tool_calls = this.getTool_calls();
        result = result * 59 + ($tool_calls == null ? 43 : ((Object)$tool_calls).hashCode());
        ChatToolCallFunction $function_call = this.getFunction_call();
        result = result * 59 + ($function_call == null ? 43 : ((Object)$function_call).hashCode());
        return result;
    }

    public String toString() {
        return "ChatMessage(content=" + this.getContent() + ", reasoning_content=" + this.getReasoning_content() + ", role=" + this.getRole() + ", name=" + this.getName() + ", tool_call_id=" + this.getTool_call_id() + ", tool_calls=" + String.valueOf(this.getTool_calls()) + ", function_call=" + String.valueOf(this.getFunction_call()) + ")";
    }
}

