/*
 * Decompiled with CFR 0.152.
 */
package fun.fengwk.chatjava.core.client.token;

import fun.fengwk.chatjava.core.client.token.ChatTokenizer;
import java.util.List;
import java.util.Objects;

public class ChatTokenizerChain
implements ChatTokenizer {
    private final List<ChatTokenizer> chain;

    public ChatTokenizerChain(List<ChatTokenizer> chain) {
        this.chain = Objects.requireNonNull(chain);
    }

    @Override
    public boolean support(String modelName) {
        for (ChatTokenizer tokenizer : this.chain) {
            if (!tokenizer.support(modelName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int countTokens(String text, String modelName) {
        for (ChatTokenizer tokenizer : this.chain) {
            if (!tokenizer.support(modelName)) continue;
            return tokenizer.countTokens(text, modelName);
        }
        throw new IllegalStateException(String.format("current tokenizer [%s] can not support model: %s", this, modelName));
    }
}

