/*
 * Decompiled with CFR 0.152.
 */
package fun.fengwk.chatjava.core.client.tool;

import fun.fengwk.chatjava.core.client.request.ChatTool;
import fun.fengwk.chatjava.core.client.tool.ToolFunctionHandler;
import fun.fengwk.chatjava.core.client.tool.ToolFunctionHandlerRegistry;
import fun.fengwk.chatjava.core.client.tool.ToolFunctionHandlerRegistryView;
import fun.fengwk.chatjava.core.client.util.ChatMiscUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ToolFunctionHandlerRegistrySubView
implements ToolFunctionHandlerRegistryView {
    private final ToolFunctionHandlerRegistry delegate;
    private final Set<String> names;

    public ToolFunctionHandlerRegistrySubView(ToolFunctionHandlerRegistry delegate, Collection<String> names) {
        this.delegate = Objects.requireNonNull(delegate);
        this.names = new HashSet<String>(ChatMiscUtils.nullSafe(names));
    }

    @Override
    public List<ChatTool> getTools() {
        return this.delegate.getTools().stream().filter(t -> this.names.contains(t.getFunction().getName())).collect(Collectors.toList());
    }

    @Override
    public ToolFunctionHandler getHandler(String name) {
        if (!this.names.contains(name)) {
            return null;
        }
        return this.delegate.getHandler(name);
    }

    @Override
    public ToolFunctionHandler getHandlerRequired(String name) {
        ToolFunctionHandler handler = this.getHandler(name);
        if (handler == null) {
            throw new IllegalStateException(String.format("handler '%s' not exists", name));
        }
        return handler;
    }

    @Override
    public Set<String> getAllNames() {
        HashSet<String> allNames = new HashSet<String>(this.names);
        Set<String> delegateNames = this.delegate.getAllNames();
        allNames.retainAll(delegateNames);
        return allNames;
    }
}

