/*
 * Decompiled with CFR 0.152.
 */
package fun.fengwk.chatjava.core.client.tool;

import fun.fengwk.chatjava.core.client.tool.JsonSchema;
import fun.fengwk.chatjava.core.client.tool.ReflectToolFunctionHandler;
import fun.fengwk.chatjava.core.client.tool.ToolFunctionHandler;
import fun.fengwk.chatjava.core.client.tool.annotation.ToolFunction;
import fun.fengwk.chatjava.core.client.tool.annotation.ToolFunctionParam;
import fun.fengwk.chatjava.core.client.util.ChatMiscUtils;
import fun.fengwk.chatjava.core.client.util.relfect.TypeResolver;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;

public class ToolFunctionParser {
    public List<ToolFunctionHandler> parse(Object object) {
        ArrayList<ToolFunctionHandler> handlers = new ArrayList<ToolFunctionHandler>();
        this.doParse(object, handlers);
        return handlers;
    }

    private void doParse(Object object, List<ToolFunctionHandler> handlers) {
        for (Method method : ChatMiscUtils.getAllDeclaredMethods(object.getClass())) {
            ToolFunction toolFunction = ChatMiscUtils.findAnnotation(method, ToolFunction.class);
            if (toolFunction == null) continue;
            if (!CharSequence.class.isAssignableFrom(method.getReturnType())) {
                throw new IllegalStateException("@ToolFunction should return CharSequence type");
            }
            ReflectToolFunctionHandler toolFunctionHandler = new ReflectToolFunctionHandler();
            toolFunctionHandler.setName(method.getDeclaringClass().getSimpleName() + "_" + method.getName());
            toolFunctionHandler.setDescription(toolFunction.description());
            toolFunctionHandler.setParameters(this.parseParameters(method));
            toolFunctionHandler.setMethod(method);
            toolFunctionHandler.setTarget(object);
            handlers.add(toolFunctionHandler);
        }
    }

    private JsonSchema parseParameters(Method method) {
        JsonSchema root = new JsonSchema();
        root.setType("object");
        root.setProperties(new LinkedHashMap<String, JsonSchema>());
        root.setRequired(new ArrayList<String>());
        for (Parameter parameter : method.getParameters()) {
            ToolFunctionParam toolFunctionParam = ChatMiscUtils.findAnnotation(parameter, ToolFunctionParam.class);
            if (toolFunctionParam == null) {
                throw new IllegalStateException(String.format("%s must be annotated with @ToolFunctionParam", String.format("%s->%s", method.getName(), parameter.getName())));
            }
            String name = toolFunctionParam.name();
            root.getProperties().put(name, this.parseParameter(parameter.getParameterizedType(), String.format("%s->%s", method.getName(), name)));
            if (!toolFunctionParam.required()) continue;
            root.getRequired().add(name);
        }
        return root;
    }

    private JsonSchema parseParameter(Type type, String pathTrace) {
        JsonSchema jsonSchema = new JsonSchema();
        jsonSchema.setJavaType(type);
        if (type instanceof Class) {
            Class<?> clazz = (Class<?>)type;
            if (Byte.class.isAssignableFrom(clazz = ChatMiscUtils.boxedIfPrimitiveType(clazz)) || Short.class.isAssignableFrom(clazz) || Integer.class.isAssignableFrom(clazz) || Long.class.isAssignableFrom(clazz) || BigInteger.class.isAssignableFrom(clazz) || AtomicInteger.class.isAssignableFrom(clazz) || AtomicLong.class.isAssignableFrom(clazz) || LongAdder.class.isAssignableFrom(clazz)) {
                jsonSchema.setType("integer");
            } else if (Number.class.isAssignableFrom(clazz)) {
                jsonSchema.setType("number");
            } else if (CharSequence.class.isAssignableFrom(clazz)) {
                jsonSchema.setType("string");
            } else if (Boolean.class.isAssignableFrom(clazz)) {
                jsonSchema.setType("boolean");
            } else if (Collection.class.isAssignableFrom(clazz)) {
                jsonSchema.setType("array");
                JsonSchema any = new JsonSchema();
                any.setType("any");
                jsonSchema.setItems(any);
            } else if (clazz.isArray()) {
                jsonSchema.setType("array");
                jsonSchema.setItems(this.parseParameter(clazz.getComponentType(), pathTrace + "[]"));
            } else {
                jsonSchema.setType("object");
                jsonSchema.setProperties(new LinkedHashMap<String, JsonSchema>());
                for (Field field : ChatMiscUtils.getAllDeclaredFields(clazz)) {
                    jsonSchema.getProperties().put(field.getName(), this.parseParameter(field.getGenericType(), pathTrace + "->" + field.getName()));
                }
            }
        } else if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type rawType = pt.getRawType();
            if (rawType instanceof Class && Collection.class.isAssignableFrom((Class)rawType)) {
                ParameterizedType collectionPt = new TypeResolver(type).as(Collection.class).asParameterizedType();
                jsonSchema.setType("array");
                jsonSchema.setItems(this.parseParameter(collectionPt.getActualTypeArguments()[0], pathTrace + "[]"));
            } else {
                jsonSchema.setType("any");
            }
        } else if (type instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)type;
            jsonSchema.setType("array");
            jsonSchema.setItems(this.parseParameter(gat.getGenericComponentType(), pathTrace + "[]"));
        } else {
            jsonSchema.setType("any");
        }
        return jsonSchema;
    }
}

