/*
 * Decompiled with CFR 0.152.
 */
package fun.fengwk.chatjava.core.client.tool;

import fun.fengwk.chatjava.core.client.ChatCompletionsResponse;
import fun.fengwk.chatjava.core.client.StreamChatListener;
import fun.fengwk.chatjava.core.client.util.ChatUtils;
import java.util.LinkedList;

public class ToolStreamChatListener
implements StreamChatListener {
    private final LinkedList<ChatCompletionsResponse> emptyDeltaResponseBuffer = new LinkedList();
    private final StreamChatListener delegate;
    private volatile boolean function;

    public ToolStreamChatListener(StreamChatListener delegate) {
        this.delegate = delegate;
    }

    @Override
    public void onReceive(ChatCompletionsResponse response) {
        if (ChatUtils.isEmptyDelta(response)) {
            this.emptyDeltaResponseBuffer.offer(response);
        } else if (this.function || ChatUtils.isToolCalls(response)) {
            this.function = true;
        } else {
            this.consumeLeftBuffer();
            this.delegate.onReceive(response);
        }
    }

    @Override
    public void onError(Throwable throwable) {
        if (!this.function) {
            this.consumeLeftBuffer();
            this.delegate.onError(throwable);
        }
    }

    @Override
    public void onComplete() {
        if (!this.function) {
            this.consumeLeftBuffer();
            this.delegate.onComplete();
        }
    }

    private void consumeLeftBuffer() {
        while (!this.emptyDeltaResponseBuffer.isEmpty()) {
            this.delegate.onReceive(this.emptyDeltaResponseBuffer.poll());
        }
    }

    public boolean isFunction() {
        return this.function;
    }
}

