/*
 * Decompiled with CFR 0.152.
 */
package fun.fengwk.chatjava.core.client.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;

public class ChatMiscUtils {
    public static final String EMPTY = "";
    private static final int BUFFER_SIZE = 4096;
    private static final Map<Class<?>, Class<?>> BOXED_MAP;

    private ChatMiscUtils() {
    }

    public static <T> boolean isEmpty(Collection<T> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <T> boolean isNotEmpty(Collection<T> collection) {
        return !ChatMiscUtils.isEmpty(collection);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isNotEmpty(String str) {
        return !ChatMiscUtils.isEmpty(str);
    }

    public static <T> Collection<T> nullSafe(Collection<T> collection) {
        return collection == null ? Collections.emptyList() : collection;
    }

    public static <T> List<T> nullSafe(List<T> list, Supplier<List<T>> defaultSupplier) {
        return list == null ? defaultSupplier.get() : list;
    }

    public static String nullSafe(String str) {
        return str == null ? EMPTY : str;
    }

    public static <S, T> T nullSafeMap(S obj, Function<S, T> mapper) {
        return obj == null ? null : (T)mapper.apply(obj);
    }

    public static <E> E tryGetLast(List<E> list) {
        return list == null || list.isEmpty() ? null : (E)list.get(list.size() - 1);
    }

    public static String toString(InputStream input, Charset charset) throws IOException {
        try (ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();){
            int len;
            byte[] buf = new byte[4096];
            while ((len = input.read(buf)) != -1) {
                bytesOut.write(buf, 0, len);
            }
            String string = bytesOut.toString(charset);
            return string;
        }
    }

    public static Set<Method> getAllDeclaredMethods(Class<?> clazz) {
        HashSet<Method> allDeclaredMethods = new HashSet<Method>();
        while (clazz != null) {
            Method[] declaredMethods = clazz.getDeclaredMethods();
            allDeclaredMethods.addAll(Arrays.asList(declaredMethods));
            clazz = clazz.getSuperclass();
        }
        return allDeclaredMethods;
    }

    public static Set<Field> getAllDeclaredFields(Class<?> clazz) {
        HashSet<Field> allDeclaredFields = new HashSet<Field>();
        while (clazz != null) {
            Field[] declaredFields = clazz.getDeclaredFields();
            allDeclaredFields.addAll(Arrays.asList(declaredFields));
            clazz = clazz.getSuperclass();
        }
        return allDeclaredFields;
    }

    public static <A extends Annotation> A findAnnotation(AnnotatedElement annotatedElement, Class<A> annotationType) {
        return ChatMiscUtils.doFindAnnotation(annotatedElement, annotationType, new HashSet<Class<? extends Annotation>>());
    }

    public static <A extends Annotation> A doFindAnnotation(AnnotatedElement annotatedElement, Class<A> annotationType, Set<Class<? extends Annotation>> visited) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = annotatedElement.getDeclaredAnnotations()) {
            if (!visited.add(annotation.annotationType())) continue;
            if (annotation.annotationType() == annotationType) {
                return (A)((Annotation)annotationType.cast(annotation));
            }
            A superAnno = ChatMiscUtils.doFindAnnotation(annotation.annotationType(), annotationType, visited);
            if (superAnno == null) continue;
            return superAnno;
        }
        return null;
    }

    public static Object invokeMethod(Method method, Object target, Object[] params) {
        try {
            return method.invoke(target, params);
        }
        catch (Exception ex) {
            ChatMiscUtils.handleReflectionException(ex);
            throw new IllegalStateException("Should never get here");
        }
    }

    public static Class<?> boxedIfPrimitiveType(Class<?> clazz) {
        Class<?> packClass = BOXED_MAP.get(clazz);
        if (packClass != null) {
            return packClass;
        }
        return clazz;
    }

    private static void handleReflectionException(Exception ex) {
        if (ex instanceof NoSuchMethodException) {
            throw new IllegalStateException("Method not found: " + ex.getMessage());
        }
        if (ex instanceof IllegalAccessException) {
            throw new IllegalStateException("Could not access method or field: " + ex.getMessage());
        }
        if (ex instanceof InvocationTargetException) {
            ChatMiscUtils.rethrowRuntimeException(ex);
        }
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }

    private static void rethrowRuntimeException(Throwable ex) {
        if (ex instanceof RuntimeException) {
            throw (RuntimeException)ex;
        }
        if (ex instanceof Error) {
            throw (Error)ex;
        }
        throw new UndeclaredThrowableException(ex);
    }

    static {
        HashMap boxedMap = new HashMap();
        boxedMap.put(Byte.TYPE, Byte.class);
        boxedMap.put(Short.TYPE, Short.class);
        boxedMap.put(Integer.TYPE, Integer.class);
        boxedMap.put(Long.TYPE, Long.class);
        boxedMap.put(Float.TYPE, Float.class);
        boxedMap.put(Double.TYPE, Double.class);
        boxedMap.put(Character.TYPE, Character.class);
        boxedMap.put(Boolean.TYPE, Boolean.class);
        BOXED_MAP = boxedMap;
    }
}

